<div id="livefot-matches" class="livefot-container">
    <div class="livefot-date-nav">
        <button class="prev-date group">
            <svg class="toggle-arrow" width="24" height="24" viewBox="0 0 24 24" fill="none"
                 stroke="currentColor" stroke-width="2" stroke-linecap="round"
                 stroke-linejoin="round" style="transform: rotate(0deg); transition: transform 0.3s ease;">
                <polyline points="15 6 9 12 15 18"></polyline>
            </svg>
        </button>
        <span class="current-date group"></span>
        <button class="next-date group">
            <svg class="toggle-arrow" width="24" height="24" viewBox="0 0 24 24" fill="none"
                 stroke="currentColor" stroke-width="2" stroke-linecap="round"
                 stroke-linejoin="round" style="transform: rotate(0deg); transition: transform 0.3s ease;">
                <polyline points="9 6 15 12 9 18"></polyline>
            </svg>
        </button>
        <div class="date-calendar-wrapper group">
            <button type="button" class="calendar-icon-button group" id="calendar-button">
                <img
                    src="<?php echo esc_url( LIVEFOT_PLUGIN_URL . 'assets/images/calendar.svg' ); ?>"
                    alt="<?php esc_attr_e( 'Open calendar', 'livefot-matches' ); ?>"
                    class="calendar-icon vector"
                    width="20"
                    height="20"
                />
                <span class="sr-only"><?php esc_html_e( 'Open calendar', 'livefot-matches' ); ?></span>
            </button>
            <input type="text" id="livefot-datepicker" class="vector sr-only" autocomplete="off" />
        </div>
    </div>

    <div class="livefot-matches-list group">
        <!-- Matches will appear here -->
    </div>
</div>

<?php
// Path to your CSS file
$css_file = plugin_dir_path( __FILE__ ) . 'assets/css/container-style.css';

// Use file modification time for versioning (fallback to plugin version)
$version = file_exists( $css_file )
    ? filemtime( $css_file )
    : LIVEFOT_VERSION;

// Register a “virtual” style handle with version for cache busting
wp_register_style(
    'livefot-matches-style',
    false,          // no external URL
    [],             // no dependencies
    $version        // version string
);
wp_enqueue_style( 'livefot-matches-style' );

// Inject the CSS inline
if ( file_exists( $css_file ) ) {
    $css_content = file_get_contents( $css_file );
    wp_add_inline_style( 'livefot-matches-style', $css_content );
}
?>
