<?php
/**
 * LiveChatAI WordPress Plugin - Uninstall Script
 * 
 * Fired when the plugin is uninstalled.
 * This file is responsible for cleaning up all plugin data.
 * 
 * @package LiveChatAI
 * @version 1.0.0
 * @license GPL-2.0+
 */

/*
LiveChatAI WordPress Plugin
Copyright (C) 2024 LiveChatAI Team

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License along
with this program; if not, write to the Free Software Foundation, Inc.,
51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
*/

// If uninstall not called from WordPress, exit
if ( ! defined( 'WP_UNINSTALL_PLUGIN' ) ) {
    exit;
}

/**
 * Clean up plugin data on uninstall
 */
function livechatai_uninstall_cleanup() {
    // Remove plugin options
    delete_option( 'livechatai_chatbot_id' );
    
    // Remove any transients
    delete_transient( 'livechatai_validation_cache' );
    
    // Remove any user meta related to the plugin
    delete_metadata( 'user', 0, 'livechatai_dismiss_notice', '', true );
    
    // For multisite installations, clean up each site
    if ( is_multisite() ) {
        // Get all sites in the network
        $sites = get_sites( array(
            'fields' => 'ids',
            'number' => 0, // Get all sites
        ) );
        
        foreach ( $sites as $site_id ) {
            switch_to_blog( $site_id );
            
            // Remove options for this site
            delete_option( 'livechatai_chatbot_id' );
            delete_transient( 'livechatai_validation_cache' );
            
            restore_current_blog();
        }
    }
    
    // Clear any cached data
    wp_cache_flush();
}

// Run the cleanup
livechatai_uninstall_cleanup(); 