<?php
/**
 * Plugin Name: LiveChatAI
 * Plugin URI: https://livechatai.com/blog/how-to-add-ai-chatbot-on-wordpress-website
 * Description: Easily embed your LiveChatAI chatbots into WordPress sites using shortcodes, widgets, or blocks. Transform your customer support with AI-powered conversations that resolve 70% of queries instantly.
 * Version: 1.0.0
 * Author: LiveChatAI Team
 * Author URI: https://livechatai.com/
 * License: GPL-2.0+
 * License URI: http://www.gnu.org/licenses/gpl-2.0.txt
 * Text Domain: livechatai
 * Domain Path: /languages
 * Requires at least: 5.0
 * Tested up to: 6.8
 * Requires PHP: 7.4
 *
 * @package LiveChatAI
 * @version 1.0.0
 * @author LiveChatAI Team
 * @copyright 2024 LiveChatAI Team
 * @license GPL-2.0+
 */

/*
LiveChatAI WordPress Plugin
Copyright (C) 2024 LiveChatAI Team

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License along
with this program; if not, write to the Free Software Foundation, Inc.,
51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
*/

// Prevent direct access
if ( ! defined( 'ABSPATH' ) ) {
    exit;
}

// Define plugin constants
define( 'LIVECHATAI_VERSION', '1.0.0' );
define( 'LIVECHATAI_PLUGIN_DIR', plugin_dir_path( __FILE__ ) );
define( 'LIVECHATAI_PLUGIN_URL', plugin_dir_url( __FILE__ ) );
define( 'LIVECHATAI_PLUGIN_BASENAME', plugin_basename( __FILE__ ) );

// Include necessary files
require_once LIVECHATAI_PLUGIN_DIR . 'includes/class-livechatai.php';
require_once LIVECHATAI_PLUGIN_DIR . 'includes/class-livechatai-security.php';

// WordPress automatically loads translations for plugins hosted on WordPress.org since version 4.6
// No manual load_plugin_textdomain() call needed

// Initialize the plugin
function livechatai_init() {
    $plugin = new LiveChatAI();
    $plugin->run();
}
add_action( 'plugins_loaded', 'livechatai_init' );

// Activation hook
register_activation_hook( __FILE__, 'livechatai_activate' );

function livechatai_activate() {
    // Add default options
    add_option( 'livechatai_chatbot_id', '' );
    
    // Flush rewrite rules if needed
    flush_rewrite_rules();
}

// Deactivation hook
register_deactivation_hook( __FILE__, 'livechatai_deactivate' );

function livechatai_deactivate() {
    // Clean up if needed
    flush_rewrite_rules();
}

// Uninstall hook
register_uninstall_hook( __FILE__, 'livechatai_uninstall' );

function livechatai_uninstall() {
    // Remove plugin options
    delete_option( 'livechatai_chatbot_id' );
    
    // Clean up any other data if needed
} 