/* eslint-disable */

/**
 * WordPress Gutenberg Block for LiveChatAI
 * This is WordPress-specific code, not Next.js
 */
(function() {
    'use strict';

    const { registerBlockType } = wp.blocks;
    const { InspectorControls } = wp.blockEditor;
    const { PanelBody, TextControl, SelectControl } = wp.components;
    const { __ } = wp.i18n;
    const { createElement } = wp.element;

    registerBlockType('livechatai/embed', {
        title: __('LiveChatAI', 'livechatai'),
        description: __('Embed your LiveChatAI chatbot', 'livechatai'),
        icon: 'format-chat',
        category: 'widgets',
        keywords: [
            __('chat', 'livechatai'),
            __('chatbot', 'livechatai'),
            __('livechatai', 'livechatai'),
        ],
        attributes: {
            chatbotId: {
                type: 'string',
                default: '',
            },
        },
                edit: function(props) {
            const { attributes, setAttributes } = props;
            const { chatbotId } = attributes;

            return [
                createElement(InspectorControls, { key: 'inspector' },
                    createElement(PanelBody, {
                        title: __('LiveChatAI Settings', 'livechatai'),
                        initialOpen: true,
                    },
                        createElement(TextControl, {
                            label: __('Chatbot ID', 'livechatai'),
                            help: __('Enter your chatbot ID from LiveChatAI dashboard. Leave empty to use default from plugin settings.', 'livechatai'),
                            value: chatbotId,
                            placeholder: __('e.g., YOUR_DATA_ID', 'livechatai'),
                            onChange: function(newValue) {
                                setAttributes({ chatbotId: newValue });
                            },
                        }),
                        createElement('div', {
                            style: {
                                marginTop: '12px',
                                padding: '12px',
                                background: '#e8f4fd',
                                borderRadius: '4px',
                                fontSize: '13px',
                                color: '#0073aa',
                            }
                        },
                            createElement('strong', null, __('Quick Setup:', 'livechatai')),
                            createElement('br'),
                            __('Dashboard → Embed & Integrate → Add as Messenger → Copy data-id value', 'livechatai')
                        )
                    )
                ),
                createElement('div', {
                    key: 'preview',
                    className: 'livechatai-block-preview',
                    style: {
                        padding: '24px',
                        border: '1px solid #e5e7eb',
                        borderRadius: '8px',
                        textAlign: 'center',
                        background: '#ffffff',
                        color: '#374151',
                        fontSize: '14px',
                        margin: '20px 0',
                    },
                },
                    // Main content
                    createElement('div', {
                        style: {
                            display: 'flex',
                            alignItems: 'center',
                            justifyContent: 'center',
                            gap: '12px',
                            marginBottom: '16px',
                        },
                    },
                        createElement('span', {
                            className: 'dashicons dashicons-format-chat',
                            style: { 
                                fontSize: '24px',
                                color: '#3b82f6'
                            }
                        }),
                        createElement('div', {
                            style: { textAlign: 'left' }
                        },
                            createElement('div', {
                                style: { 
                                    fontSize: '16px', 
                                    fontWeight: '600', 
                                    color: '#111827',
                                    marginBottom: '4px'
                                }
                            }, __('LiveChatAI Messenger', 'livechatai')),
                            createElement('div', {
                                style: { 
                                    fontSize: '13px', 
                                    color: '#6b7280'
                                }
                            }, __('AI-powered customer support', 'livechatai'))
                        )
                    ),
                    
                    // Status info
                    createElement('div', {
                        style: {
                            fontSize: '13px',
                            color: '#6b7280',
                            marginBottom: '12px',
                        }
                    },
                        chatbotId ? 
                            __('Custom ID: ', 'livechatai') + chatbotId.substring(0, 15) + '...' :
                            __('Using default chatbot ID', 'livechatai')
                    ),
                    
                    // Note
                    createElement('div', {
                        style: {
                            fontSize: '12px',
                            color: '#6b7280',
                        }
                    },
                        __('Messenger widget will appear automatically on frontend', 'livechatai')
                    )
                )
            ];
        },
        save: function(props) {
            const { attributes } = props;
            const { chatbotId } = attributes;

            // Generate shortcode
            let shortcode = '[livechatai';
            if (chatbotId) {
                shortcode += ' chatbot_id="' + chatbotId + '"';
            }
            shortcode += ']';

            return shortcode;
        },
    });
})();
