# 🚀 LiveChatAI WordPress Plugin

Transform your WordPress site with AI-powered customer support that resolves 70% of queries instantly. No coding required – just paste your chatbot ID and you're live!

![LiveChatAI Plugin](https://livechatai.com/images/wordpress-plugin-banner.png)

## ✨ What Makes This Special?

- **5-Minute Setup**: Paste your chatbot ID and you're live
- **70% Resolution Rate**: Proven to resolve most customer queries automatically  
- **24/7 AI Support**: Your customers get instant help, any time
- **Seamless Human Handoff**: Complex issues automatically transfer to your team
- **Multiple Integration Options**: Auto-load, shortcodes, widgets, or Gutenberg blocks
- **Modern, Professional UI**: Beautiful admin interface that's a joy to use

## 🚀 Quick Start

> **Get from zero to AI support in 5 minutes** ⚡

### Step 1: Install & Activate
```bash
# Upload plugin to your WordPress site
wp-content/plugins/livechatai/
```
1. Download the plugin folder
2. Upload to your WordPress site's `/wp-content/plugins/` directory  
3. Activate through **Plugins** menu in WordPress admin

### Step 2: Quick Configuration
1. Navigate to **Settings → LiveChatAI** in WordPress admin
2. Enter your **Chatbot ID** (we'll show you how to get this below)
3. Click **Save Settings** 
4. 🎉 **That's it!** Your AI assistant is now live on your website

### Step 3: Get Your Chatbot ID

#### Step 1: Create or Access Your Chatbot
1. Login to [LiveChatAI Dashboard](https://app.livechatai.com)
2. If you don't have a chatbot yet:
   - Click **"Create New Chatbot"** or **"+ New Chatbot"**
   - Follow the setup wizard to create your AI assistant
   - Configure your chatbot settings and data sources
3. If you already have a chatbot, select it from your dashboard

#### Step 2: Navigate to Embed & Integrate
1. Once your chatbot is selected, look for the top navigation menu
2. Click on **"Embed & Integrate"** tab
3. You'll see various integration options for your chatbot

#### Step 3: Find Your Chatbot ID
1. In the **"Embed & Integrate"** section, look for **"Add as Messenger"**
2. You'll see a code snippet that looks like this:
   ```html
   <script
     src="https://app.livechatai.com/embed.js"
     data-id="YOUR_DATA_ID"
     async defer>
   </script>
   ```
3. Your **Chatbot ID** is the value in the `data-id` attribute
4. In the example above, the Chatbot ID is: `YOUR_DATA_ID`

#### Step 4: Copy Your Chatbot ID
1. Highlight and copy the ID from the `data-id` attribute (without quotes)
2. This unique identifier is what you'll paste into the WordPress plugin settings
3. Each chatbot has its own unique ID - make sure you're copying from the correct chatbot

## 🎯 Usage Options

Choose how you want to add LiveChatAI to your WordPress site:

### 🚀 Automatic (Recommended)
```php
// No code needed - just save your chatbot ID!
// Widget appears automatically on all pages
```
Perfect for: **Most websites** - Set it and forget it!

### 📝 Shortcode Integration  
```php
// Basic usage
[livechatai]

// With custom chatbot ID
[livechatai chatbot_id="your-chatbot-id"]
```
Perfect for: **Specific pages** - Control exactly where chat appears

### 🎨 WordPress Widget
```
Appearance → Widgets → Add "LiveChatAI"
```
Perfect for: **Sidebars & footers** - Traditional WordPress placement

### 🔗 Gutenberg Block
```
Add Block → Search "LiveChatAI" → Configure & Publish
```
Perfect for: **Modern WordPress** - Visual block editor integration

## 🛠️ How It Works

This plugin adds a messenger script to your website's footer:
```html
<script src="https://app.livechatai.com/embed.js" data-id="your-chatbot-id" async defer></script>
```

The script creates a pop-up messenger widget that visitors can use to chat with your AI assistant.

## ⚡ Key Features

| Feature | Benefit | Status |
|---------|---------|--------|
| **5-Minute Setup** | Get AI support running in minutes, not hours | ✅ |
| **70% Auto-Resolution** | Reduce support workload dramatically | ✅ |
| **24/7 Availability** | Customers get help any time, day or night | ✅ |
| **Human Handoff** | Seamlessly transfer complex issues to your team | ✅ |
| **Multi-Language** | Support customers in 95+ languages | ✅ |
| **WordPress Native** | Built specifically for WordPress - no conflicts | ✅ |
| **Mobile Optimized** | Perfect experience on all devices | ✅ |
| **Analytics Ready** | Track performance and customer satisfaction | ✅ |

### 🎨 Modern Admin Interface
- **Beautiful Design**: Professional interface that's a joy to use
- **Step-by-Step Guide**: Visual setup instructions with screenshots  
- **Real-Time Status**: See instantly if your chatbot is active
- **Quick Actions**: One-click access to dashboard and help resources

## 📁 File Structure

```
livechatai/
├── livechatai.php              # Main plugin file
├── includes/
│   └── class-livechatai.php    # Core plugin class
├── blocks/
│   └── livechatai-block.js     # Gutenberg block
├── assets/                     # Future CSS/JS files
├── languages/                  # Translation files
└── README.md                   # This file
```

## 🔧 For Developers

### Plugin Structure
- **Main Class**: `LiveChatAI` in `/includes/class-livechatai.php`
- **Hooks Used**: `wp_footer`, `admin_menu`, `admin_init`, `widgets_init`, `init`
- **Settings**: Stored in WordPress options table as `livechatai_chatbot_id`

### Key Functions
- `add_messenger_script()` - Adds script to footer
- `render_shortcode()` - Handles shortcode rendering
- `settings_page()` - Admin settings interface
- `register_gutenberg_block()` - Gutenberg block registration

### Customization
You can modify the script URL or add custom CSS by editing the `class-livechatai.php` file.

## 🐛 Troubleshooting

### Messenger not appearing?
1. **Double-check your Chatbot ID**: Make sure you copied the correct ID from the `data-id` attribute
2. **Verify ID format**: Chatbot IDs are typically 25 characters long (e.g., `YOUR_DATA_ID`)
3. **Check chatbot status**: Ensure the chatbot is active in your LiveChatAI dashboard
4. **Browser console**: Check for JavaScript errors in browser developer tools
5. **Plugin activation**: Verify the plugin is activated in WordPress

### Can't find your Chatbot ID?
- Make sure you're in the **"Embed & Integrate"** tab, not "Settings" or other tabs
- Look specifically for the **"Add as Messenger"** section
- The ID is in the script's `data-id` attribute, not the URL or other fields
- If you have multiple chatbots, make sure you're viewing the correct one

### Need custom styling?
Add CSS to your theme's `style.css`:
```css
/* Customize messenger widget */
.livechatai-widget {
    /* your custom styles */
}
```

## 🆘 Need Help?

### 📚 Documentation & Resources
- 📖 **[Complete Documentation](https://help.livechatai.com/)** - Detailed guides and tutorials
- 🚀 **[LiveChatAI Dashboard](https://app.livechatai.com)** - Manage your chatbots
- 💬 **[Community Forum](https://community.livechatai.com)** - Connect with other users
- 📧 **[Contact Support](https://livechatai.com/contact)** - Get direct help from our team

### 🐛 Found a Bug?
Create an issue in our repository or contact support with:
- WordPress version
- PHP version  
- Plugin version
- Description of the issue
- Steps to reproduce

## 📋 System Requirements

| Requirement | Minimum | Recommended |
|-------------|---------|-------------|
| **WordPress** | 5.0+ | Latest version |
| **PHP** | 7.4+ | 8.0+ |
| **Account** | Free LiveChatAI account | Paid plan for advanced features |

## 🔄 Version History

### Version 1.0.0 🎉
- ✨ **Initial Release**: Core functionality implemented
- 🎨 **Modern UI**: Beautiful admin interface  
- 📝 **Multiple Integration Options**: Shortcode, widget, Gutenberg block
- 🚀 **Auto-Loading**: Messenger appears automatically on all pages
- 📖 **Comprehensive Documentation**: Step-by-step setup guide

---

<div align="center">

**Ready to transform your customer support?** 🚀

[**Get Started with LiveChatAI →**](https://app.livechatai.com)

*Join thousands of websites already using AI-powered customer support*

**Happy Chatting!** 💬✨

</div> 