<?php
/**
 * Uninstall script for WooCommerce Font Selector
 *
 * This file is executed when the plugin is uninstalled.
 * It removes all options and data stored in the database.
 */

// Exit if accessed directly
if (!defined('ABSPATH')) {
    exit;
}

// Check if the uninstall is triggered by the plugin
if (!defined('WP_UNINSTALL_PLUGIN')) {
    exit;
}

// Remove options from the database
delete_option('live_font_preview_enable_all');
delete_option('live_font_preview_categories');
delete_option('live_font_preview_products');
delete_option('live_font_preview_fonts');
delete_option('live_font_preview_title');
delete_option('live_font_preview_text_label');
delete_option('live_font_preview_text_placeholder');
delete_option('live_font_preview_font_label');
delete_option('live_font_preview_preview_label');
delete_option('live_font_preview_preview_text');
delete_option('live_font_preview_error_text');
delete_option('live_font_preview_error_font');
delete_option('live_font_preview_cart_text_label');
delete_option('live_font_preview_cart_font_label');
delete_option('live_font_preview_order_text_label');
delete_option('live_font_preview_order_font_label');

// Optionally, you can also remove any custom database tables created by the plugin
// global $wpdb;
// $wpdb->query("DROP TABLE IF EXISTS {$wpdb->prefix}your_custom_table_name");
?>