<?php
/**
 * Admin Settings Page Template
 *
 * @package Live_Font_Preview
 * @since 1.0.0
 */

// Exit if accessed directly
if (!defined('ABSPATH')) {
    exit;
}

// Check for form submission and display messages
// phpcs:ignore WordPress.Security.NonceVerification.Recommended
if (isset($_GET['settings-updated']) && $_GET['settings-updated'] == 'true') {
    echo '<div class="notice notice-success is-dismissible"><p>' . esc_html__('Settings saved successfully!', 'live-font-preview-for-woocommerce') . '</p></div>';
}
?>

<div class="wrap woocommerce live-font-preview-for-woocommerce-settings">
    <h1><?php esc_html_e('Live Font Preview Settings', 'live-font-preview-for-woocommerce'); ?></h1>
    
    <?php settings_errors('live_font_preview_settings'); ?>
    
    <div class="live-font-preview-for-woocommerce-settings-wrapper">
       <form method="post" action="" id="live-font-preview-for-woocommerce-form">
    <?php wp_nonce_field('live_font_preview_save_settings', 'live_font_preview_nonce'); ?>
    
            
            <div class="live-font-preview-for-woocommerce-tabs">
                <!-- Tab Navigation -->
                <nav class="nav-tab-wrapper">
                    <a href="#general" class="nav-tab nav-tab-active" data-tab="general">
                        <span class="dashicons dashicons-admin-settings"></span>
                        <?php esc_html_e('General', 'live-font-preview-for-woocommerce'); ?>
                    </a>
                    <a href="#fonts" class="nav-tab" data-tab="fonts">
                        <span class="dashicons dashicons-editor-textcolor"></span>
                        <?php esc_html_e('Fonts', 'live-font-preview-for-woocommerce'); ?>
                    </a>
                    <a href="#labels" class="nav-tab" data-tab="labels">
                        <span class="dashicons dashicons-tag"></span>
                        <?php esc_html_e('Labels & Text', 'live-font-preview-for-woocommerce'); ?>
                    </a>
                </nav>
                
                <!-- General Tab Content -->
                <div id="general" class="tab-content active">
                    <h2><?php esc_html_e('General Settings', 'live-font-preview-for-woocommerce'); ?></h2>
                    <table class="form-table">
                        <tbody>
                            <tr>
                                <th scope="row">
                                    <label for="live_font_preview_enable_all">
                                        <?php esc_html_e('Enable for All Products', 'live-font-preview-for-woocommerce'); ?>
                                    </label>
                                </th>
                                <td>
                                    <label class="live-font-preview-for-woocommerce-switch">
                                        <input 
                                            type="checkbox" 
                                            id="live_font_preview_enable_all" 
                                            name="live_font_preview_enable_all" 
                                            value="yes" 
                                            <?php checked(get_option('live_font_preview_enable_all', 'no'), 'yes'); ?>
                                        />
                                        <span class="live-font-preview-for-woocommerce-slider"></span>
                                    </label>
                                    <p class="description">
                                        <?php esc_html_e('Enable font selector for all products. If disabled, you can choose specific categories or products below.', 'live-font-preview-for-woocommerce'); ?>
                                    </p>
                                </td>
                            </tr>
                            
                            <tr class="live-font-preview-for-woocommerce-conditional">
                                <th scope="row">
                                    <label for="live_font_preview_categories">
                                        <?php esc_html_e('Enable for Categories', 'live-font-preview-for-woocommerce'); ?>
                                    </label>
                                </th>
                                <td>
                                    <?php
                                    $live_font_preview_selected_categories = get_option('live_font_preview_categories', array());
                                    if (!is_array($live_font_preview_selected_categories)) {
                                        $live_font_preview_selected_categories = array();
                                    }
                                    $live_font_preview_categories = get_terms(array(
                                        'taxonomy' => 'product_cat',
                                        'hide_empty' => false
                                    ));
                                    ?>
                                    <select name="live_font_preview_categories[]" id="live_font_preview_categories" multiple="multiple" class="wc-enhanced-select" style="width: 100%; max-width: 400px;" data-placeholder="<?php esc_attr_e('Select categories...', 'live-font-preview-for-woocommerce'); ?>">
                                        <?php if (!is_wp_error($live_font_preview_categories) && !empty($live_font_preview_categories)) : ?>
                                            <?php foreach ($live_font_preview_categories as $live_font_preview_category) : ?>
                                                <option value="<?php echo esc_attr($live_font_preview_category->term_id); ?>" <?php selected(in_array($live_font_preview_category->term_id, $live_font_preview_selected_categories), true); ?>>
                                                    <?php echo esc_html($live_font_preview_category->name); ?>
                                                </option>
                                            <?php endforeach; ?>
                                        <?php endif; ?>
                                    </select>
                                    <p class="description">
                                        <?php esc_html_e('Select product categories where font selector should be displayed.', 'live-font-preview-for-woocommerce'); ?>
                                    </p>
                                </td>
                            </tr>
                            
                            <tr class="live-font-preview-for-woocommerce-conditional">
                                <th scope="row">
                                    <label for="live_font_preview_products">
                                        <?php esc_html_e('Enable for Specific Products', 'live-font-preview-for-woocommerce'); ?>
                                    </label>
                                </th>
                                <td>
                                    <?php
                                    $live_font_preview_selected_products = get_option('live_font_preview_products', array());
                                    if (!is_array($live_font_preview_selected_products)) {
                                        $live_font_preview_selected_products = array();
                                    }
                                    ?>
                                    <select name="live_font_preview_products[]" id="live_font_preview_products" class="wc-product-search" style="width: 100%; max-width: 400px;" multiple="multiple" data-placeholder="<?php esc_attr_e('Search for a product...', 'live-font-preview-for-woocommerce'); ?>" data-action="woocommerce_json_search_products_and_variations">
                                        <?php
                                        if (!empty($live_font_preview_selected_products)) {
                                            foreach ($live_font_preview_selected_products as $live_font_preview_product_id) {
                                                $live_font_preview_product = wc_get_product($live_font_preview_product_id);
                                                if ($live_font_preview_product) {
                                                    echo '<option value="' . esc_attr($live_font_preview_product_id) . '" selected="selected">' . esc_html($live_font_preview_product->get_name()) . '</option>';
                                                }
                                            }
                                        }
                                        ?>
                                    </select>
                                    <p class="description">
                                        <?php esc_html_e('Select specific products where font selector should be displayed. Start typing to search.', 'live-font-preview-for-woocommerce'); ?>
                                    </p>
                                </td>
                            </tr>
                        </tbody>
                    </table>
                </div>
                
                <!-- Fonts Tab Content -->
                <div id="fonts" class="tab-content">
                    <h2><?php esc_html_e('Font Management', 'live-font-preview-for-woocommerce'); ?></h2>
                    <table class="form-table">
                        <tbody>
                            <tr>
                                <th scope="row">
                                    <label><?php esc_html_e('Available Fonts', 'live-font-preview-for-woocommerce'); ?></label>
                                </th>
                                <td>
                                    <div class="live-font-preview-for-woocommerce-fonts-manager">
                                        <div class="live-font-preview-for-woocommerce-fonts-list">
                                            <?php
                                            $live_font_preview_fonts = get_option('live_font_preview_fonts', array());
                                            if (empty($live_font_preview_fonts) || !is_array($live_font_preview_fonts)) {
                                                $live_font_preview_fonts = array(
                                                    'Open Sans',
                                                    'Roboto',
                                                    'Lato',
                                                    'Montserrat',
                                                    'Oswald',
                                                    'Source Sans Pro',
                                                    'Raleway',
                                                    'PT Sans',
                                                    'Ubuntu',
                                                    'Nunito'
                                                );
                                            }
                                            
                                            if (!empty($live_font_preview_fonts)) :
                                                foreach ($live_font_preview_fonts as $live_font_preview_font_name) :
                                                    if (empty($live_font_preview_font_name)) continue;
                                                ?>
                                                    <div class="live-font-preview-for-woocommerce-font-item">
                                                        <input type="hidden" name="live_font_preview_fonts[]" value="<?php echo esc_attr($live_font_preview_font_name); ?>" />
                                                        <span class="font-name" style="font-family: '<?php echo esc_attr($live_font_preview_font_name); ?>', sans-serif;">
                                                            <?php echo esc_html($live_font_preview_font_name); ?>
                                                        </span>
                                                        <button type="button" class="button remove-font" title="<?php esc_attr_e('Remove Font', 'live-font-preview-for-woocommerce'); ?>">
                                                            <span class="dashicons dashicons-trash"></span>
                                                        </button>
                                                    </div>
                                                <?php
                                                endforeach;
                                            endif;
                                            ?>
                                        </div>
                                        
                                        <div class="live-font-preview-for-woocommerce-add-font">
                                            <input type="text" id="new-font-name" placeholder="<?php esc_attr_e('Enter Google Font name...', 'live-font-preview-for-woocommerce'); ?>" class="regular-text" />
                                            <button type="button" id="add-font-btn" class="button button-secondary">
                                                <span class="dashicons dashicons-plus-alt"></span>
                                                <?php esc_html_e('Add Font', 'live-font-preview-for-woocommerce'); ?>
                                            </button>
                                        </div>
                                        
                                        <p class="description">
                                            <?php 
                                            printf(
                                                /* translators: %s: Google Fonts URL */
                                                esc_html__('Enter exact Google Font names (case-sensitive). You can find them at %s. Popular fonts: Roboto, Open Sans, Lato, Montserrat, Source Sans Pro.', 'live-font-preview-for-woocommerce'),
                                                '<a href="https://fonts.google.com" target="_blank" rel="noopener">Google Fonts</a>'
                                            ); ?>
                                        </p>
                                        
                                        <?php if (empty($live_font_preview_fonts)) : ?>
                                            <div class="live-font-preview-for-woocommerce-empty-fonts">
                                                <p><?php esc_html_e('No fonts configured yet. Add your first font above.', 'live-font-preview-for-woocommerce'); ?></p>
                                            </div>
                                        <?php endif; ?>
                                    </div>
                                </td>
                            </tr>
                        </tbody>
                    </table>
                </div>
                
                <!-- Labels Tab Content -->
                <div id="labels" class="tab-content">
                    <h2><?php esc_html_e('Labels & Messages', 'live-font-preview-for-woocommerce'); ?></h2>
                    <table class="form-table">
                        <tbody>
                            <tr>
                                <th scope="row">
                                    <label for="live_font_preview_title">
                                        <?php esc_html_e('Section Title', 'live-font-preview-for-woocommerce'); ?>
                                    </label>
                                </th>
                                <td>
                                    <input 
                                        type="text" 
                                        id="live_font_preview_title" 
                                        name="live_font_preview_title" 
                                        value="<?php echo esc_attr(get_option('live_font_preview_title', __('Customize Your Text', 'live-font-preview-for-woocommerce'))); ?>" 
                                        class="regular-text"
                                    />
                                    <p class="description"><?php esc_html_e('The main heading shown above the font selector on product pages.', 'live-font-preview-for-woocommerce'); ?></p>
                                </td>
                            </tr>
                            
                            <tr>
                                <th scope="row">
                                    <label for="live_font_preview_text_label">
                                        <?php esc_html_e('Text Input Label', 'live-font-preview-for-woocommerce'); ?>
                                    </label>
                                </th>
                                <td>
                                    <input 
                                        type="text" 
                                        id="live_font_preview_text_label" 
                                        name="live_font_preview_text_label" 
                                        value="<?php echo esc_attr(get_option('live_font_preview_text_label', __('Your Text', 'live-font-preview-for-woocommerce'))); ?>" 
                                        class="regular-text"
                                    />
                                    <p class="description"><?php esc_html_e('Label for the custom text input field.', 'live-font-preview-for-woocommerce'); ?></p>
                                </td>
                            </tr>
                            
                            <tr>
                                <th scope="row">
                                    <label for="live_font_preview_text_placeholder">
                                        <?php esc_html_e('Text Input Placeholder', 'live-font-preview-for-woocommerce'); ?>
                                    </label>
                                </th>
                                <td>
                                    <input 
                                        type="text" 
                                        id="live_font_preview_text_placeholder" 
                                        name="live_font_preview_text_placeholder" 
                                        value="<?php echo esc_attr(get_option('live_font_preview_text_placeholder', __('Enter your custom text here...', 'live-font-preview-for-woocommerce'))); ?>" 
                                        class="regular-text"
                                    />
                                    <p class="description"><?php esc_html_e('Placeholder text shown in the text input field.', 'live-font-preview-for-woocommerce'); ?></p>
                                </td>
                            </tr>
                            
                            <tr>
                                <th scope="row">
                                    <label for="live_font_preview_font_label">
                                        <?php esc_html_e('Font Select Label', 'live-font-preview-for-woocommerce'); ?>
                                    </label>
                                </th>
                                <td>
                                    <input 
                                        type="text" 
                                        id="live_font_preview_font_label" 
                                        name="live_font_preview_font_label" 
                                        value="<?php echo esc_attr(get_option('live_font_preview_font_label', __('Choose Font', 'live-font-preview-for-woocommerce'))); ?>" 
                                        class="regular-text"
                                    />
                                    <p class="description"><?php esc_html_e('Label for the font selection dropdown.', 'live-font-preview-for-woocommerce'); ?></p>
                                </td>
                            </tr>
                            
                            <tr>
                                <th scope="row">
                                    <label for="live_font_preview_preview_label">
                                        <?php esc_html_e('Preview Label', 'live-font-preview-for-woocommerce'); ?>
                                    </label>
                                </th>
                                <td>
                                    <input 
                                        type="text" 
                                        id="live_font_preview_preview_label" 
                                        name="live_font_preview_preview_label" 
                                        value="<?php echo esc_attr(get_option('live_font_preview_preview_label', __('Preview', 'live-font-preview-for-woocommerce'))); ?>" 
                                        class="regular-text"
                                    />
                                    <p class="description"><?php esc_html_e('Label shown above the live preview area.', 'live-font-preview-for-woocommerce'); ?></p>
                                </td>
                            </tr>
                            
                            <tr>
                                <th scope="row">
                                    <label for="live_font_preview_preview_text">
                                        <?php esc_html_e('Default Preview Text', 'live-font-preview-for-woocommerce'); ?>
                                    </label>
                                </th>
                                <td>
                                    <input 
                                        type="text" 
                                        id="live_font_preview_preview_text" 
                                        name="live_font_preview_preview_text" 
                                        value="<?php echo esc_attr(get_option('live_font_preview_preview_text', __('This is how your text will look', 'live-font-preview-for-woocommerce'))); ?>" 
                                        class="regular-text"
                                    />
                                    <p class="description"><?php esc_html_e('Default text shown in the preview when no custom text is entered.', 'live-font-preview-for-woocommerce'); ?></p>
                                </td>
                            </tr>
                            
                            <tr>
                                <th scope="row">
                                    <label for="live_font_preview_error_text">
                                        <?php esc_html_e('Text Required Error', 'live-font-preview-for-woocommerce'); ?>
                                    </label>
                                </th>
                                <td>
                                    <input 
                                        type="text" 
                                        id="live_font_preview_error_text" 
                                        name="live_font_preview_error_text" 
                                        value="<?php echo esc_attr(get_option('live_font_preview_error_text', __('Please enter your custom text.', 'live-font-preview-for-woocommerce'))); ?>" 
                                        class="regular-text"
                                    />
                                    <p class="description"><?php esc_html_e('Error message when customer tries to add to cart without entering text.', 'live-font-preview-for-woocommerce'); ?></p>
                                </td>
                            </tr>
                            
                            <tr>
                                <th scope="row">
                                    <label for="live_font_preview_error_font">
                                        <?php esc_html_e('Font Required Error', 'live-font-preview-for-woocommerce'); ?>
                                    </label>
                                </th>
                                <td>
                                    <input 
                                        type="text" 
                                        id="live_font_preview_error_font" 
                                        name="live_font_preview_error_font" 
                                        value="<?php echo esc_attr(get_option('live_font_preview_error_font', __('Please select a font.', 'live-font-preview-for-woocommerce'))); ?>" 
                                        class="regular-text"
                                    />
                                    <p class="description"><?php esc_html_e('Error message when customer tries to add to cart without selecting a font.', 'live-font-preview-for-woocommerce'); ?></p>
                                </td>
                            </tr>
                            
                            <tr>
                                <th scope="row">
                                    <label for="live_font_preview_cart_text_label">
                                        <?php esc_html_e('Cart Text Label', 'live-font-preview-for-woocommerce'); ?>
                                    </label>
                                </th>
                                <td>
                                    <input 
                                        type="text" 
                                        id="live_font_preview_cart_text_label" 
                                        name="live_font_preview_cart_text_label" 
                                        value="<?php echo esc_attr(get_option('live_font_preview_cart_text_label', __('Custom Text', 'live-font-preview-for-woocommerce'))); ?>" 
                                        class="regular-text"
                                    />
                                    <p class="description"><?php esc_html_e('Label for custom text shown in cart and checkout.', 'live-font-preview-for-woocommerce'); ?></p>
                                </td>
                            </tr>
                            
                            <tr>
                                <th scope="row">
                                    <label for="live_font_preview_cart_font_label">
                                        <?php esc_html_e('Cart Font Label', 'live-font-preview-for-woocommerce'); ?>
                                    </label>
                                </th>
                                <td>
                                    <input 
                                        type="text" 
                                        id="live_font_preview_cart_font_label" 
                                        name="live_font_preview_cart_font_label" 
                                        value="<?php echo esc_attr(get_option('live_font_preview_cart_font_label', __('Font', 'live-font-preview-for-woocommerce'))); ?>" 
                                        class="regular-text"
                                    />
                                    <p class="description"><?php esc_html_e('Label for font selection shown in cart and checkout.', 'live-font-preview-for-woocommerce'); ?></p>
                                </td>
                            </tr>
                            
                            <tr>
                                <th scope="row">
                                    <label for="live_font_preview_order_text_label">
                                        <?php esc_html_e('Order Text Label', 'live-font-preview-for-woocommerce'); ?>
                                    </label>
                                </th>
                                <td>
                                    <input 
                                        type="text" 
                                        id="live_font_preview_order_text_label" 
                                        name="live_font_preview_order_text_label" 
                                        value="<?php echo esc_attr(get_option('live_font_preview_order_text_label', __('Custom Text', 'live-font-preview-for-woocommerce'))); ?>" 
                                        class="regular-text"
                                    />
                                    <p class="description"><?php esc_html_e('Label for custom text shown in order details and emails.', 'live-font-preview-for-woocommerce'); ?></p>
                                </td>
                            </tr>
                            
                            <tr>
                                <th scope="row">
                                    <label for="live_font_preview_order_font_label">
                                        <?php esc_html_e('Order Font Label', 'live-font-preview-for-woocommerce'); ?>
                                    </label>
                                </th>
                                <td>
                                    <input 
                                        type="text" 
                                        id="live_font_preview_order_font_label" 
                                        name="live_font_preview_order_font_label" 
                                        value="<?php echo esc_attr(get_option('live_font_preview_order_font_label', __('Font', 'live-font-preview-for-woocommerce'))); ?>" 
                                        class="regular-text"
                                    />
                                    <p class="description"><?php esc_html_e('Label for font selection shown in order details and emails.', 'live-font-preview-for-woocommerce'); ?></p>
                                </td>
                            </tr>
                        </tbody>
                    </table>
                </div>
                
                <!-- Submit Button -->
                 <div class="live-font-preview-for-woocommerce-submit-wrapper">
        <?php submit_button(__('Save Settings', 'live-font-preview-for-woocommerce'), 'primary', 'live_font_preview_save', true, array('id' => 'live-font-preview-for-woocommerce-submit')); ?>
    </div>
            </div>
        </form>
    </div>
</div>
