<?php
/**
 * Plugin Name: Live Font Preview for WooCommerce
 * Plugin URI:  https://wordpress.org/plugins/live-font-preview-for-woocommerce/
 * Description: Allow customers to preview and select fonts for custom engravings and text on WooCommerce products.
 * Version: 1.0
 * Author: WP Majestic
 * Author URI: https://wpmajestic.com
 * Text Domain: live-font-preview-for-woocommerce
 * Domain Path: /languages
 * Requires Plugins: woocommerce
 * WC requires at least: 5.0
 * WC tested up to: 8.5
 * HPOS compatible: yes
 * License: GPL v2 or later
 */

// Exit if accessed directly
if (!defined('ABSPATH')) {
    exit;
}

// Define plugin constants
define('LIVE_FONT_PREVIEW_VERSION', '1.0');
define('LIVE_FONT_PREVIEW_PLUGIN_DIR', plugin_dir_path(__FILE__));
define('LIVE_FONT_PREVIEW_PLUGIN_URL', plugin_dir_url(__FILE__));
define('LIVE_FONT_PREVIEW_ASSETS_URL', LIVE_FONT_PREVIEW_PLUGIN_URL . 'assets/');

/**
 * Main Class
 */
class Live_Font_Preview_Main {
    
    /**
     * Instance
     */
    private static $instance = null;
    
    /**
     * Initialized
     */
    private $initialized = false;
    
    /**
     * Get instance
     */
    public static function get_instance() {
        if (self::$instance === null) {
            self::$instance = new self();
        }
        return self::$instance;
    }
    
    /**
     * Constructor
     */
    private function __construct() {
        add_action('plugins_loaded', array($this, 'init'));
        add_action('before_woocommerce_init', array($this, 'declare_hpos_compatibility'));
        add_filter('plugin_action_links_' . plugin_basename(__FILE__), array($this, 'add_action_links'));
    }
    
    /**
     * Add action links to plugin list
     */
    public function add_action_links($links) {
        $settings_link = '<a href="' . admin_url('admin.php?page=live-font-preview-for-woocommerce') . '">' . __('Settings', 'live-font-preview-for-woocommerce') . '</a>';
        array_unshift($links, $settings_link);
        return $links;
    }

    /**
     * Declare HPOS Compatibility
     */
    public function declare_hpos_compatibility() {
        if (class_exists(\Automattic\WooCommerce\Utilities\FeaturesUtil::class)) {
            \Automattic\WooCommerce\Utilities\FeaturesUtil::declare_compatibility('custom_order_tables', __FILE__, true);
        }
    }
    
    /**
     * Init
     */
    public function init() {
        if ($this->initialized) {
            return;
        }
        
        // Load text domain - handled automatically/by WordPress.org
        // load_plugin_textdomain('live-font-preview-for-woocommerce', false, dirname(plugin_basename(__FILE__)) . '/languages');
        
        // Check requirements
        if (!$this->check_requirements()) {
            return;
        }
        
        // Load only the main class - avoid duplicates
        require_once LIVE_FONT_PREVIEW_PLUGIN_DIR . 'includes/class-live-font-preview-for-woocommerce.php';
        
        // Initialize main class only
        if (class_exists('Live_Font_Preview')) {
            new Live_Font_Preview();
        }
        
        $this->initialized = true;
    }
    
    private function check_requirements() {
        if (!class_exists('WooCommerce')) {
            add_action('admin_notices', function() {
                echo '<div class="notice notice-error"><p>Live Font Preview for WooCommerce requires WooCommerce to be active.</p></div>';
            });
            return false;
        }
        return true;
    }
}

// Initialize
Live_Font_Preview_Main::get_instance();