<?php
/**
 * Settings page functionality
 *
 * @package Live_Font_Preview
 * @since 1.0.0
 */

// Exit if accessed directly
if (!defined('ABSPATH')) {
    exit;
}

/**
 * Live_Font_Preview_Settings Class
 */
class Live_Font_Preview_Settings {
    
    /**
     * Constructor
     */
    public function __construct() {
        add_action('admin_init', array($this, 'register_settings'));
    }
    
    /**
     * Register settings
     */
    public function register_settings() {
        // Register all the settings
        // Enable All - Boolean/Checkbox
        register_setting('live_font_preview_settings', 'live_font_preview_enable_all', array(
            'type' => 'string',
            'sanitize_callback' => array($this, 'sanitize_checkbox')
        ));

        // Categories - Array of Integers
        register_setting('live_font_preview_settings', 'live_font_preview_categories', array(
            'type' => 'array',
            'sanitize_callback' => array($this, 'sanitize_id_list')
        ));

        // Products - Array of Integers
        register_setting('live_font_preview_settings', 'live_font_preview_products', array(
            'type' => 'array',
            'sanitize_callback' => array($this, 'sanitize_id_list')
        ));

        // Fonts - Array of Strings
        register_setting('live_font_preview_settings', 'live_font_preview_fonts', array(
            'type' => 'array',
            'sanitize_callback' => array($this, 'sanitize_text_list')
        ));

        // Text Fields
        $text_fields = array(
            'live_font_preview_title',
            'live_font_preview_text_label',
            'live_font_preview_text_placeholder',
            'live_font_preview_font_label',
            'live_font_preview_preview_label',
            'live_font_preview_preview_text',
            'live_font_preview_error_text',
            'live_font_preview_error_font',
            'live_font_preview_cart_text_label',
            'live_font_preview_cart_font_label',
            'live_font_preview_order_text_label',
            'live_font_preview_order_font_label'
        );

        foreach ($text_fields as $field) {
            register_setting('live_font_preview_settings', $field, array(
                'type' => 'string',
                'sanitize_callback' => 'sanitize_text_field'
            ));
        }
    }
    
    /**
     * Sanitize Checkbox (yes/no)
     */
    public function sanitize_checkbox($value) {
        return ($value === 'yes') ? 'yes' : 'no';
    }

    /**
     * Sanitize List of IDs
     */
    public function sanitize_id_list($value) {
        if (!is_array($value)) {
            return array();
        }
        return array_map('absint', $value);
    }

    /**
     * Sanitize List of Text Strings
     */
    public function sanitize_text_list($value) {
        if (!is_array($value)) {
            return array();
        }
        return array_map('sanitize_text_field', $value);
    }
    
    /**
     * Display the settings page
     */
    public function display() {
        // Include the template file
        include LIVE_FONT_PREVIEW_PLUGIN_DIR . 'templates/admin/settings-page.php';
    }
}