(function ($) {
    'use strict';
    console.log('LiveFontPreview: File loaded');
    // alert('Live Font Preview loaded!'); // Uncomment if console is not visible

    /**
     * Font Selector Frontend Logic
     */
    var LiveFontPreview = {
        init: function () {
            this.bindEvents();
            this.loadInitialFonts();
        },

        bindEvents: function () {
            // Font selection change
            $(document).on('change', '.live-font-preview-for-woocommerce-font-select', this.handleFontChange.bind(this));

            // Text input change (real-time)
            $(document).on('input keyup paste', '.live-font-preview-for-woocommerce-text-input', this.handleTextChange.bind(this));
        },

        loadInitialFonts: function () {
            // Check for any pre-selected fonts on load
            $('.live-font-preview-for-woocommerce-font-select').each(function () {
                var initialFont = $(this).val();
                if (initialFont) {
                    LiveFontPreview.loadGoogleFont(initialFont);
                }
            });
        },

        handleFontChange: function (e) {
            var $select = $(e.currentTarget);
            var fontName = $select.val();
            var $container = $select.closest('.live-font-preview-for-woocommerce-wrapper');
            var $preview = $container.find('.live-font-preview-for-woocommerce-preview');

            console.log('LiveFontPreview: Change event detected', fontName);

            if (!fontName) {
                // Reset to inherit or default
                $preview.css('font-family', '');
                return;
            }

            console.log('Live Font Preview: Loading font ' + fontName);

            // 1. Load the font
            this.loadGoogleFont(fontName);

            // 2. Apply to preview
            // We use a fallback stack just in case
            $preview.css('font-family', '"' + fontName + '", sans-serif');
        },

        handleTextChange: function (e) {
            var $input = $(e.currentTarget);
            var text = $input.val();
            var $container = $input.closest('.live-font-preview-for-woocommerce-wrapper');
            var $preview = $container.find('.live-font-preview-for-woocommerce-preview');
            var defaultText = $preview.data('default-text') || 'This is how your text will look';

            if (text.length > 0) {
                $preview.text(text);
                $preview.removeClass('empty');
            } else {
                $preview.text(defaultText);
                $preview.addClass('empty');
            }
        },

        loadGoogleFont: function (fontName) {
            if (!fontName) return;

            // Simple check to avoid loading common web-safe fonts from Google
            var safeFonts = ['Arial', 'Helvetica', 'Times New Roman', 'Courier New', 'Verdana', 'Georgia', 'Palatino', 'Garamond', 'Bookman', 'Comic Sans MS', 'Trebuchet MS', 'Arial Black', 'Impact'];

            if (safeFonts.includes(fontName)) {
                return;
            }

            // Create ID for the link element
            var fontId = 'live-font-preview-' + fontName.toLowerCase().replace(/[^a-z0-9]/g, '-');

            // Check if already loaded
            if (document.getElementById(fontId)) {
                return;
            }

            var link = document.createElement('link');
            link.id = fontId;
            link.rel = 'stylesheet';
            link.href = 'https://fonts.googleapis.com/css2?family=' + encodeURIComponent(fontName) + ':wght@400;700&display=swap';

            document.head.appendChild(link);
        }
    };

    // Initialize on ready
    $(document).ready(function () {
        LiveFontPreview.init();
    });

})(jQuery);