# Live Font Preview for WooCommerce

**Contributors:** wpmajestic  
**Tags:** woocommerce, fonts, font selector, product customization, engraving, typography, live preview  
**Requires at least:** 6.0  
**Tested up to:** 6.7  
**Requires PHP:** 7.4  
**Stable tag:** 1.0  
**License:** GPLv2 or later  
**License URI:** https://www.gnu.org/licenses/gpl-2.0.html

Allow customers to preview and select fonts for custom engravings and text on WooCommerce products with a real-time live preview.

## Description

Live Font Preview for WooCommerce allows you to offer real-time text previews with a variety of fonts for your customizable products. This empowers customers to see exactly what their personalized items will look like, increasing confidence and conversion rates.

Perfect for stores selling engraved jewelry, custom apparel, embroidery, or personalized gifts, this plugin adds a sleek font selection dropdown and text input field directly to your product pages.

### Key Features:

*   **Real-Time Preview:** Customers see exactly how their text looks in their chosen font instantly
*   **Google Fonts Integration:** Securely loads high-quality fonts for accurate rendering
*   **Flexible Display Logic:** Enable globally, per category, or for specific products only
*   **High-Performance Order Storage (HPOS) Compatible**
*   **Cart & Order Integration:** Selected fonts and text are clearly displayed in the cart, checkout, and order emails
*   **Customizable Labels:** Easily change field labels and placeholders to match your store's language
*   Compatible with WooCommerce Blocks checkout
*   Compatible with classic WooCommerce checkout

## Installation

1.  Upload the plugin files to the `/wp-content/plugins/live-font-preview-for-woocommerce` directory, or install the plugin through the WordPress plugins screen directly.
2.  Activate the plugin through the 'Plugins' screen in WordPress.
3.  Go to 'WooCommerce → Live Font Preview' to configure your settings.

## Usage

1.  Navigate to `WooCommerce → Live Font Preview` in your WordPress admin.
2.  Enable the feature globally or select specific categories/products.
3.  Choose which Google Fonts you want to offer to your customers.
4.  Save your settings.
5.  Visit a product page to see the live font selector in action.

## Frequently Asked Questions

### Does this work with the new WooCommerce Blocks checkout?

Yes, this plugin is compatible with both the traditional WooCommerce checkout experience and the new WooCommerce Blocks checkout.

### Can I add my own custom fonts?

Currently, the plugin supports a curated list of Google Fonts. Custom font upload support is planned for a future version.

### Is it compatible with HPOS (High-Performance Order Storage)?

Yes, this plugin is fully compatible with WooCommerce's High-Performance Order Storage (HPOS).

### Will the chosen font show up in the order email?

Yes, the "Font" and "Custom Text" fields are saved as order item metadata, so they will appear in the admin order view and in customer emails.

## Changelog

### 1.0
*   Initial release
*   Added live font preview with Google Fonts
*   Added High-Performance Order Storage (HPOS) support
*   Compatible with both classic checkout and WooCommerce Blocks

## Upgrade Notice

### 1.0
Initial release with HPOS support.