<?php
/**
 * Tab Stylist
 *
 * @package LiveComposer
 */

// Prevent direct access to the file.
if ( ! defined( 'ABSPATH' ) ) {
	header( 'HTTP/1.0 403 Forbidden' );
	exit;
}
?>

<div class="wrap lc-admin-tab-content lc-wrap lc-centered-panels lc-wider-panel lc-tab-stylist">

	<div class="dslc-panel lc-divided-panels padding-medium">
		<div class="lc-panel-half">
			<h3 class="lc-huge margin-top-half">Style any website element with +60 design controls</h3>
			<p class="lc-larger-text">Do you need more design options? Check out <a href="https://livecomposerplugin.com/stylist" target="_blank">Stylist: styling plugin for WordPress</a>.</p>
			<ul>
				<li>Visually customize any element on the page with easy to use design panel.</li>
				<li>Edit custom CSS with live preview.</li>
				<li>Works great with any page builder including Gutenberg editor.</li>
				<li>Advanced responsive mode.</li>
				<li>+60 extra design options.</li>
			</ul>
		</div>
		<div class="lc-panel-half lc-image-column" style="text-align:center;">
			<img alt="Stylist" src="<?php echo DS_LIVE_COMPOSER_URL; ?>/images/stylist.png">
			<p><a href="/wp-admin/plugin-install.php?s=StylistWP&tab=search&type=term" class="button button-primary button-hero">FREE DOWNLOAD</a></p>
		</div>
	</div>

</div>
