<?php
/**
 * Front-end rendering logic.
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

/**
 * Render the podcast embed.
 *
 * @param string $content The post content.
 * @return string The modified content.
 */
function himoose_insert_embed( $content ) {
	// Only on single posts and in the main loop.
	if ( ! is_singular( 'post' ) || ! in_the_loop() || ! is_main_query() ) {
		return $content;
	}

	global $post;

	// Check if shortcode is present in content.
	if ( has_shortcode( $post->post_content, 'himoose_podcast' ) ) {
		return $content;
	}

	// Check if auto-insert is enabled.
	$auto_insert = get_option( 'himoose_auto_insert' );
	if ( '1' !== $auto_insert ) {
		return $content;
	}

	// Get the embed HTML.
	$embed_html = get_post_meta( $post->ID, '_himoose_embed_html', true );

	if ( ! empty( $embed_html ) ) {
		// Output trusted embed HTML generated by the Hi, Moose service.
		// This is not user-supplied content.
		$content = $embed_html . $content;
	}

	return $content;
}
add_filter( 'the_content', 'himoose_insert_embed' );

/**
 * Shortcode handler.
 *
 * @param array $atts Shortcode attributes.
 * @return string The embed HTML.
 */
function himoose_shortcode( $atts ) {
	global $post;

	if ( ! $post ) {
		return '';
	}

	$embed_html = get_post_meta( $post->ID, '_himoose_embed_html', true );

	if ( ! empty( $embed_html ) ) {
		// Output trusted embed HTML generated by the Hi, Moose service.
		// This is not user-supplied content.
		return $embed_html;
	}

	return '';
}
add_shortcode( 'himoose_podcast', 'himoose_shortcode' );
