# Listen to This Article (WordPress Plugin)

Listen to This Article is an open-source WordPress plugin by Hi, Moose that adds
a podcast-style audio version of blog posts using AI-generated narration.

## What this plugin does
- Adds a “Listen to this article” text-to-speech audio player to WordPress posts
- Embeds podcast-style audio generated by Hi, Moose
- Includes full, crawlable transcripts and PodcastEpisode schema
- Supports Classic Editor and Block Editor
- Improves accessibility, engagement, and modern SEO/AEO visibility

## How it works
This plugin connects to the Hi, Moose [AEO platform](https://himoose.com/aeo-platform) so you can generate and embed
podcast-style audio versions of your content directly from the WordPress editor (Classic Editor or Block Editor).

In the editor, you can either:
- **Load available audio** (previously generated episodes for your domain), or
- **Generate audio** for the post/page with a few customization options.

Once selected, you **preview the audio** in the meta box and then click **Update/Publish** to save the selection.
On posts, the player can be auto-inserted at the top of the content (or placed manually via shortcode). Pages require the shortcode.

Audio playback, transcripts, and structured data are delivered as a single,
self-contained embed that requires no manual audio file management.

## How to use
1. Install the plugin and add your Hi, Moose API key in WordPress settings.
2. Edit a post or page and find the **Audio Content** meta box.
3. Click **Load available audio** or **Generate audio**.
4. Preview the audio, then click **Update/Publish** to save.
5. For pages (and for posts if auto-insert is disabled), add the shortcode `[himoose_podcast]` where you want the player.

## Why this exists
This project was built to help publishers improve accessibility and prepare
content for modern, AI-powered search experiences (ChatGPT, Gemini, Perplexity,
and other answer engines).

## Why transcripts matter (SEO & AEO)

Each embedded podcast includes a **full, crawlable transcript** rendered directly
on the page (not hidden behind JavaScript-only playback).

### Traditional SEO
- Adds substantial, relevant on-page text without changing the original article
- Captures conversational phrasing and long-tail queries
- Surfaces terminology that may not appear verbatim in written content

### Answer Engine Optimization (AEO)
Modern AI-powered search systems rely heavily on:
- Clear explanations
- Natural language phrasing
- Well-structured, first-hand text sources

Podcast-style transcripts are especially effective because they:
- Use conversational language
- Explicitly explain concepts
- Mirror how people ask and answer questions verbally

This makes them easier for AI systems to extract, summarize, and reference
accurately.

### Accessibility & engagement
- Improves accessibility for users who prefer or require text alternatives
- Increases time on page by allowing users to listen or read
- Supports multimodal consumption without fragmenting content

> The goal is not to replace written content, but to **augment it** with a format
> that performs well across both human and AI-driven discovery systems.

## WordPress.org listing
https://wordpress.org/plugins/listen-to-this-article

## Related
- Hi, Moose — Modern search optimization tools for SEO, AEO, and AI discovery  
  https://himoose.com

## License
GPL v2 or later
