# List Plugin Details (from wordpress.org)

[![WordPress plugin](https://img.shields.io/wordpress/plugin/dt/list-plugin-details.svg?style=flat)](https://wordpress.org/plugins/list-plugin-details/) [![WordPress plugin](https://img.shields.io/wordpress/plugin/v/list-plugin-details.svg?style=flat)](https://wordpress.org/plugins/list-plugin-details/) [![WordPress](https://img.shields.io/wordpress/v/list-plugin-details.svg?style=flat)]() [![License](https://img.shields.io/badge/license-GPL%203.0%2B-lightgrey.svg?style=flat-square)](http://www.gnu.org/licenses/gpl-3.0.txt)

This tiny plugin lists selected plugin details which are provided on wordpress.org. It allows you to show a showcase of your developed or your preferred plugins, which are listed on wordpress.org.
Whether you are a plugin developer, or you want to show a list of several plugins. List Plugin Details retrieves details from wordpress.org like downloads, rating and number of reviews and shows them in cards. You will find a huge number of settings to transform the list into your list.
Just add a shortcode on the page you want and enjoy the plugin list.

## Style and layout
List Plugin Details is just providing the technical structure to show the retrieved details on your website. This plugin does not come with any style. So, it is important for you to add you own classes and/or to write some CSS to show your individual list. YOu have also the possibility to modify the showcase template and transform it to your needs.

## Installation
Upload the files to your server and put it in your folder /plugins/.
Activate the plugin, enter the API key and check the settings page.

## Demo
If you want to see how List Plugin Details works, please check out our own <a href="https://www.kybernetik-services.com/plugins/free/?utm_source=wordpress_org&utm_medium=plugin&utm_campaign=list-plugin-details&utm_content=demo" target="_blank">page</a>.

## Frequently Asked Questions

### How can I add the list to my page?

Just add the shortcode [wpo_plugin_showcase] to your page or post.

### Is the showcase ready for Gutenberg?

Yes, you can use the shortcode [wpo_plugin_showcase] with Gutenberg blocks.

### Do I have to be a plugin author?

No. List Plugin Details grabs the public details of the plugin from wordpress.org.

### Can I only list the plugins that I am the author of?

No. List Plugin Details lists the  public details of any plugin which is available on wordpress.org. Create a showcase of your own, or your preferred plugins.

### Does List Plugin Details provides several layouts?

No. List Plugin Details is just providing the technical structure for the list. It doesn't come with a style. But you have the option to add your own classes to the tags to make the list to your list.

### Why do you call dependencies from shields.io?

List Plugin Details allows you to show badges from shields.io on your plugin page. This needs to get the badge directly from img.shields.io. You do not need to open an account. But make sure this is noted in your GDPR related information.
By default, this option is not enabled. You need to actively decide to display the badge on your page. If you keep this option disabled there is not remote call from shields.io.

## Translations

If you would like to add a translation in your language, please do it on [translate.wordpress.org](https://translate.wordpress.org/projects/wp-plugins/list-plugin-details/)

## Known issues
Depending on the number of plugins you want to get the details from, it takes a second to retrieve and show the results. Not sure if this is an issue, but it can definitely be improved in the future.

## Rating

Rating is the new gold :-). If you like this plugin, please share your positive experience with the world.
If you don't like the plugin, or it is not working in your environment, please visit the [forum](https://wordpress.org/support/plugin/list-plugin-details/) and check, if there is already a solution for you. If not, please ask and you will get a solution.
Please do not rate less than five stars before I have had the opportunity to investigate your problem - if there is one :-)

## Contribution

You are warmly welcome to contribute to List Plugin Details. No matter if you find a typo or a bug, if you want to suggest a cool new feature or if you want to help us to translate it... we would like to hear you. Here's how you could get started.

1. [Report](https://wordpress.org/support/plugin/list-plugin-details/) a minor issue or a major bug
2. [Provide feedback](https://wordpress.org/support/plugin/list-plugin-details/) on enhancements
3. Send pull requests with fixes and improvements