<?php
/**
 * Plugin Name: LISA AI Shopping Assistant
 * Plugin URI: https://codenamelisa.com
 * Description: AI-powered shopping assistant that helps convert browsers into buyers through natural conversation and product discovery.
 * Version: 1.0.1
 * Author: Codename Clan
 * Author URI: https://codenamelisa.com/about
 * License: GPL v2 or later
 * License URI: https://www.gnu.org/licenses/gpl-2.0.html
 * Text Domain: lisa-ai-shopping-assistant
 * Requires at least: 5.8
 * Requires PHP: 7.4
 * WC requires at least: 5.0
 * WC tested up to: 8.5
 */

// Prevent direct access
if (!defined('ABSPATH')) {
    exit;
}

// Define plugin constants
define('LISA_AI_VERSION', '1.0.1');
define('LISA_AI_PLUGIN_DIR', plugin_dir_path(__FILE__));
define('LISA_AI_PLUGIN_URL', plugin_dir_url(__FILE__));
define('LISA_AI_PLUGIN_BASENAME', plugin_basename(__FILE__));

// Backend API URL (your Railway-hosted Python backend)
define('LISA_AI_API_URL', 'https://lisa-ai-backend-production.up.railway.app');

/**
 * Check if WooCommerce is active
 */
function lisa_ai_check_woocommerce() {
    if (!class_exists('WooCommerce')) {
        add_action('admin_notices', 'lisa_ai_woocommerce_missing_notice');
        return false;
    }
    return true;
}

/**
 * Admin notice for missing WooCommerce
 */
function lisa_ai_woocommerce_missing_notice() {
    ?>
    <div class="notice notice-error">
        <p><?php esc_html_e('LISA AI Shopping Assistant requires WooCommerce to be installed and activated.', 'lisa-ai-shopping-assistant'); ?></p>
    </div>
    <?php
}

/**
 * Plugin activation hook
 */
function lisa_ai_activate() {
    // Check for WooCommerce
    if (!class_exists('WooCommerce')) {
        deactivate_plugins(plugin_basename(__FILE__));
        wp_die(esc_html__('LISA AI Shopping Assistant requires WooCommerce to be installed and activated.', 'lisa-ai-shopping-assistant'));
    }
    
    // Set default options
    $default_options = array(
        'api_key' => '',
        'store_id' => '',
        'widget_enabled' => true,
        'widget_position' => 'bottom-right',
        'widget_color' => '#0066cc',
        'welcome_message' => 'Hi! I\'m LISA, your shopping assistant. How can I help you today?',
    );
    
    add_option('lisa_ai_settings', $default_options);
    
    // Flush rewrite rules
    flush_rewrite_rules();
}
register_activation_hook(__FILE__, 'lisa_ai_activate');

/**
 * Plugin deactivation hook
 */
function lisa_ai_deactivate() {
    // Flush rewrite rules
    flush_rewrite_rules();
}
register_deactivation_hook(__FILE__, 'lisa_ai_deactivate');

/**
 * Initialize the plugin
 */
function lisa_ai_init() {
    // Check for WooCommerce
    if (!lisa_ai_check_woocommerce()) {
        return;
    }
    
    // Include required files
    require_once LISA_AI_PLUGIN_DIR . 'includes/class-lisa-admin.php';
    require_once LISA_AI_PLUGIN_DIR . 'includes/class-lisa-api-client.php';
    require_once LISA_AI_PLUGIN_DIR . 'includes/class-lisa-widget.php';
    require_once LISA_AI_PLUGIN_DIR . 'includes/class-lisa-product-sync.php';
    
    // Initialize classes
    if (is_admin()) {
        new Lisa_Admin();
    }
    
    new Lisa_Widget();
    new Lisa_Product_Sync();
}
add_action('plugins_loaded', 'lisa_ai_init');

/**
 * Add settings link on plugins page
 */
function lisa_ai_settings_link($links) {
    $settings_link = '<a href="admin.php?page=lisa-ai-settings">' . esc_html__('Settings', 'lisa-ai-shopping-assistant') . '</a>';
    array_unshift($links, $settings_link);
    return $links;
}
add_filter('plugin_action_links_' . LISA_AI_PLUGIN_BASENAME, 'lisa_ai_settings_link');

/**
 * Declare HPOS compatibility for WooCommerce
 */
add_action('before_woocommerce_init', function() {
    if (class_exists('\Automattic\WooCommerce\Utilities\FeaturesUtil')) {
        \Automattic\WooCommerce\Utilities\FeaturesUtil::declare_compatibility('custom_order_tables', __FILE__, true);
    }
});