/**
 * LISA AI Admin Scripts
 */

(function ($) {
    'use strict';

    $(document).ready(function () {
        // Initialize color picker
        $('.lisa-color-picker').wpColorPicker();

        // Sync products button
        $('#lisa-sync-products').on('click', function () {
            var $button = $(this);
            var $status = $('#lisa-sync-status');

            $button.prop('disabled', true);
            $status.removeClass('success error').addClass('loading').text('Syncing products...');

            $.ajax({
                url: ajaxurl,
                type: 'POST',
                data: {
                    action: 'lisa_sync_all_products',
                    nonce: lisaAdminSettings.nonce
                },
                success: function (response) {
                    if (response.success) {
                        $status.removeClass('loading').addClass('success').text(response.data.message);
                    } else {
                        $status.removeClass('loading').addClass('error').text(response.data.message);
                    }
                },
                error: function () {
                    $status.removeClass('loading').addClass('error').text('An error occurred. Please try again.');
                },
                complete: function () {
                    $button.prop('disabled', false);
                }
            });
        });

        // ========================
        // Store Registration
        // ========================
        $('#lisa-register-btn').on('click', function () {
            var $btn = $(this);
            var $status = $('#lisa-reg-status');
            var storeName = $('#lisa-reg-store-name').val().trim();
            var email = $('#lisa-reg-email').val().trim();
            var storeUrl = $('#lisa-reg-url').val().trim();

            if (!storeName || !email) {
                $status.removeClass('success').addClass('error').text('Please enter your store name and email.');
                return;
            }

            $btn.prop('disabled', true).text('Registering...');
            $status.removeClass('success error').addClass('loading').text('');

            $.ajax({
                url: ajaxurl,
                type: 'POST',
                data: {
                    action: 'lisa_register_store',
                    nonce: lisaAdminSettings.nonce,
                    store_name: storeName,
                    email: email,
                    store_url: storeUrl
                },
                success: function (response) {
                    if (response.success) {
                        $status.removeClass('loading error').addClass('success').text(response.data.message + ' Reloading...');
                        setTimeout(function () {
                            window.location.reload();
                        }, 1500);
                    } else {
                        $status.removeClass('loading').addClass('error').text(response.data.message || 'Registration failed');
                        $btn.prop('disabled', false).text('Register & Get Credentials');
                    }
                },
                error: function () {
                    $status.removeClass('loading').addClass('error').text('Connection error. Please try again.');
                    $btn.prop('disabled', false).text('Register & Get Credentials');
                }
            });
        });

        // ========================
        // Plan & Billing
        // ========================
        function loadBillingStatus() {
            var $section = $('#lisa-billing-section');

            $.ajax({
                url: ajaxurl,
                type: 'POST',
                data: {
                    action: 'lisa_check_billing',
                    nonce: lisaAdminSettings.nonce
                },
                success: function (response) {
                    if (response.success && response.data && response.data.plan !== undefined) {
                        renderBillingSection(response.data);
                    } else {
                        $section.html('<p class="lisa-billing-error">Unable to load billing status. Please ensure your Store ID is configured.</p>');
                    }
                },
                error: function () {
                    $section.html('<p class="lisa-billing-error">Unable to connect to billing service.</p>');
                }
            });
        }

        function renderBillingSection(data) {
            var currentPlan = data.plan || 'free';
            var conversations = data.monthly_conversations || 0;
            var isActive = data.subscription_active || false;

            var plans = [
                { id: 'hobby', name: 'Hobby', price: 29, conversations: '3,000' },
                { id: 'growth', name: 'Growth', price: 79, conversations: '10,000' },
                { id: 'business', name: 'Business', price: 199, conversations: '30,000' }
            ];

            var html = '<div class="lisa-billing-current">';
            html += '<p><strong>Current Plan:</strong> ' + currentPlan.charAt(0).toUpperCase() + currentPlan.slice(1) + '</p>';
            html += '<p><strong>Conversations this month:</strong> ' + conversations + '</p>';

            if (isActive) {
                html += '<p class="lisa-billing-active">&#9989; Subscription active</p>';
                html += '<button type="button" id="lisa-manage-subscription" class="button button-secondary">Manage Subscription</button>';
            }

            html += '</div>';

            if (!isActive || currentPlan === 'free') {
                html += '<div class="lisa-billing-plans">';
                html += '<h3>Upgrade your plan</h3>';
                html += '<p>All plans include a 14-day free trial.</p>';
                html += '<div class="lisa-plan-cards">';

                for (var i = 0; i < plans.length; i++) {
                    var plan = plans[i];
                    var isCurrent = plan.id === currentPlan;
                    var cardClass = 'lisa-plan-card' + (isCurrent ? ' lisa-plan-current' : '');

                    html += '<div class="' + cardClass + '">';
                    html += '<h4>' + plan.name + '</h4>';
                    html += '<div class="lisa-plan-price">$' + plan.price + '<span>/month</span></div>';
                    html += '<p>' + plan.conversations + ' conversations/month</p>';

                    if (isCurrent) {
                        html += '<button type="button" class="button" disabled>Current Plan</button>';
                    } else {
                        html += '<button type="button" class="button button-primary lisa-upgrade-btn" data-plan="' + plan.id + '">Subscribe</button>';
                    }

                    html += '</div>';
                }

                html += '</div></div>';
            } else {
                // Show upgrade options for paid users
                html += '<div class="lisa-billing-plans">';
                html += '<h3>Change your plan</h3>';
                html += '<div class="lisa-plan-cards">';

                for (var j = 0; j < plans.length; j++) {
                    var p = plans[j];
                    var isCurrentPlan = p.id === currentPlan;
                    var cls = 'lisa-plan-card' + (isCurrentPlan ? ' lisa-plan-current' : '');

                    html += '<div class="' + cls + '">';
                    html += '<h4>' + p.name + '</h4>';
                    html += '<div class="lisa-plan-price">$' + p.price + '<span>/month</span></div>';
                    html += '<p>' + p.conversations + ' conversations/month</p>';

                    if (isCurrentPlan) {
                        html += '<button type="button" class="button" disabled>Current Plan</button>';
                    } else {
                        html += '<button type="button" class="button button-primary lisa-upgrade-btn" data-plan="' + p.id + '">Switch Plan</button>';
                    }

                    html += '</div>';
                }

                html += '</div></div>';
            }

            $('#lisa-billing-section').html(html);

            // Bind upgrade buttons
            $('.lisa-upgrade-btn').on('click', function () {
                var plan = $(this).data('plan');
                var $btn = $(this);
                $btn.prop('disabled', true).text('Loading...');

                $.ajax({
                    url: ajaxurl,
                    type: 'POST',
                    data: {
                        action: 'lisa_create_checkout',
                        nonce: lisaAdminSettings.nonce,
                        plan: plan
                    },
                    success: function (response) {
                        if (response.success && response.data.checkout_url) {
                            window.location.href = response.data.checkout_url;
                        } else {
                            alert('Error: ' + (response.data.message || 'Unable to create checkout session'));
                            $btn.prop('disabled', false).text('Subscribe');
                        }
                    },
                    error: function () {
                        alert('Unable to connect to billing service. Please try again.');
                        $btn.prop('disabled', false).text('Subscribe');
                    }
                });
            });

            // Bind manage subscription button
            $('#lisa-manage-subscription').on('click', function () {
                var $btn = $(this);
                $btn.prop('disabled', true).text('Loading...');

                $.ajax({
                    url: ajaxurl,
                    type: 'POST',
                    data: {
                        action: 'lisa_manage_subscription',
                        nonce: lisaAdminSettings.nonce
                    },
                    success: function (response) {
                        if (response.success && response.data.portal_url) {
                            window.location.href = response.data.portal_url;
                        } else {
                            alert('Error: ' + (response.data.message || 'Unable to open subscription management'));
                            $btn.prop('disabled', false).text('Manage Subscription');
                        }
                    },
                    error: function () {
                        alert('Unable to connect to billing service. Please try again.');
                        $btn.prop('disabled', false).text('Manage Subscription');
                    }
                });
            });
        }

        // Load billing on page load if store ID is configured
        if ($('#lisa-billing-section').length) {
            loadBillingStatus();
        }
    });

})(jQuery);