<?php

/*
Plugin Name: Linkomize
Plugin URI: https://www.bermikodplugins.com/eklenti/linkomize-pro/
Description: Create custom tracking links for Facebook and Google Ads and track real-time conversions, cart actions and other campaign metrics directly from your WordPress dashboard.
Version: 1.0.1
Author: BermikodPlugins
Author URI: https://bermikodplugins.com
License: GPLv2 or later
License URI: https://www.gnu.org/licenses/gpl-2.0.html
Text Domain: linkomize
Domain Path: /languages
*/


if (!defined('ABSPATH')) exit;


register_activation_hook(__FILE__, 'linkomize_create_table');

function linkomize_create_table() {
    global $wpdb;
    $table_name = $wpdb->prefix . 'bat_links';
    
    $charset_collate = $wpdb->get_charset_collate();
    
    $sql = "CREATE TABLE $table_name (
        id INT AUTO_INCREMENT PRIMARY KEY,
        name VARCHAR(255) NOT NULL,
        target_url TEXT NOT NULL,
        ref_code VARCHAR(255) NOT NULL UNIQUE,
        clicks INT DEFAULT 0,
        add_to_cart INT DEFAULT 0,
        purchases INT DEFAULT 0,
        created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP
    ) $charset_collate;";
    
    require_once(ABSPATH . 'wp-admin/includes/upgrade.php');
    dbDelta($sql);
}

require_once plugin_dir_path(__FILE__) . 'includes/admin-panel.php';
require_once plugin_dir_path(__FILE__) . 'includes/tracker-logic.php';
?>