<?php
if ( ! defined( 'ABSPATH' ) ) exit; 

add_action('template_redirect', function () {
    if (isset($_GET['linkomize_ref'])) {
        global $wpdb;
        $ref = sanitize_text_field($_GET['linkomize_ref']);
        $table_name = $wpdb->prefix . 'bat_links';

        $row = $wpdb->get_row($wpdb->prepare("SELECT * FROM $table_name WHERE ref_code = %s", $ref));
        if ($row) {
            // Sayaç artır
            $wpdb->query($wpdb->prepare("UPDATE $table_name SET clicks = clicks + 1 WHERE id = %d", $row->id));
           
            setcookie('linkomize_ref', $ref, time() + (7 * 24 * 60 * 60), "/");
            wp_redirect($row->target_url);
            exit;
        }
    }
});

add_action('wp_ajax_linkomize_get_stats', function() {
    global $wpdb;
    $id = intval($_POST['template_id']);
    $table_name = $wpdb->prefix . 'bat_links';
    
    $stats = $wpdb->get_row($wpdb->prepare("SELECT clicks, add_to_cart, purchases FROM $table_name WHERE id = %d", $id));
    
    wp_send_json_success($stats);
});
?>