<?php

if ( ! defined( 'ABSPATH' ) ) exit;

add_action('admin_menu', function () {
    $icon_url = trailingslashit( dirname( plugin_dir_url( __FILE__ ) ) ) . 'assets/icon-1.png';

    add_menu_page(
        'Linkomize',                    
        'Linkomize',                   
        'manage_options',             
        'linkomize',                   
        'linkomize_admin_page',       
        $icon_url,                    
        30                            
    );
});

// Enqueue admin styles
add_action('admin_enqueue_scripts', 'linkomize_admin_enqueue_scripts');

function linkomize_admin_enqueue_scripts($hook) {
    if ($hook != 'toplevel_page_linkomize') {
        return;
    }
    
    wp_add_inline_style('wp-admin', '
        .wp-list-table th, .wp-list-table td {
            padding: 12px 8px;
        }
        .button-small {
            padding: 3px 8px;
            font-size: 11px;
            margin-right: 5px;
        }
    ');
}

function linkomize_admin_page() {
    global $wpdb;
    $table_name = $wpdb->prefix . 'bat_links';

    
    if (isset($_GET['delete']) && isset($_GET['_wpnonce']) && wp_verify_nonce( sanitize_text_field( wp_unslash( $_GET['_wpnonce'] ) ), 'delete_template')) {
        $id = intval($_GET['delete']);
        $wpdb->delete($table_name, ['id' => $id]);
        echo "<div class='notice notice-success'><p>Template Deleted!</p></div>";
    }

   
    if (isset($_POST['linkomize_create']) && wp_verify_nonce( sanitize_text_field( wp_unslash( $_POST['_wpnonce'] ) ), 'create_template')) {
        $name = sanitize_text_field($_POST['linkomize_name']);
        $url = esc_url_raw($_POST['linkomize_url']);
        $ref = sanitize_text_field($_POST['linkomize_ref']);
        
     
        $exists = $wpdb->get_var($wpdb->prepare("SELECT COUNT(*) FROM $table_name WHERE ref_code = %s", $ref));
        
        if ($exists > 0) {
            echo "<div class='notice notice-error'><p>This reference code is already in use!</p></div>";
        } else {
            $result = $wpdb->insert($table_name, [
                'name' => $name,
                'target_url' => $url,
                'ref_code' => $ref
            ]);
            
            if ($result !== false) {
                echo "<div class='notice notice-success'><p>Template successfully added!</p></div>";
            } else {
echo "<div class='notice notice-error'><p>Error adding a template: " . esc_html( $wpdb->last_error ) . "</p></div>";
            }
        }
    }

  

   
    $results = $wpdb->get_results("SELECT * FROM $table_name ORDER BY created_at DESC");
    ?>
    <div class="wrap">
        <h1> linkomize Link Monitor</h1>
<div style="display: flex; gap: 20px; align-items: flex-start; flex-wrap: wrap;">

  
    <div style="flex: 1; min-width: 70%; background: white; padding: 20px; margin: 20px 0; border-radius: 8px; box-shadow: 0 2px 4px rgba(0,0,0,0.1);">
        <h2>Create New Tracking Template</h2>
        <form method="post" style="display: grid; gap: 15px; max-width: 600px;">
            <?php wp_nonce_field('create_template'); ?>

            <div>
                <label for="linkomize_name" style="display: block; margin-bottom: 5px; font-weight: bold;">Template Name:</label>
                <input type="text" id="linkomize_name" name="linkomize_name" placeholder="Ex: Facebook Advertising Campaign 1" 
                       required style="width: 100%; padding: 8px; border: 1px solid #ddd; border-radius: 4px;">
                <small style="color: #666;">Enter a unique code (use only letters, numbers and underscores)</small>
            </div>

            <div>
                <label for="linkomize_url" style="display: block; margin-bottom: 5px; font-weight: bold;">Destination URL:</label>
                <input type="url" id="linkomize_url" name="linkomize_url" placeholder="https://example.com/product-page" 
                       required style="width: 100%; padding: 8px; border: 1px solid #ddd; border-radius: 4px;">
                <small style="color: #666;">URL of the product page to be redirected to the campaign</small>
            </div>

            <div>
                <label for="linkomize_ref" style="display: block; margin-bottom: 5px; font-weight: bold;">Reference Code:</label>
                <input type="text" id="linkomize_ref" name="linkomize_ref" placeholder="fb_product_campaign_1" 
                       required style="width: 100%; padding: 8px; border: 1px solid #ddd; border-radius: 4px;">
                <small style="color: #666;">Enter a unique code (use only letters, numbers and underscores)</small>
            </div>

            <button type="submit" name="linkomize_create" class="button button-primary" style="justify-self: start;">Create Template</button>
        </form>
    </div>

    
    <div style="flex: 1; min-width: 25%;">
        <?php linkomize_show_pro_vs_free_features(); ?>
    </div>

</div>

        <div style="background: white; padding: 20px; border-radius: 8px; box-shadow: 0 2px 4px rgba(0,0,0,0.1);">
            <h2>Created Templates (<?php echo count($results); ?>)</h2>
            
            <?php if (empty($results)): ?>
                <p style="text-align: center; color: #666; padding: 40px;">No template has been created yet. You can add a new template in the form above.</p>
            <?php else: ?>
                <div style="overflow-x: auto;">
                    <table class="wp-list-table widefat fixed striped">
                        <thead>
                            <tr>
                                <th style="width: 20%;">Template Name</th>
                                <th style="width: 25%;">Tracking Link</th>
                                
                                <th style="width: 20%;">Click</th>
                               
                                
                            </tr>
                        </thead>
                        <tbody>
                            <?php foreach ($results as $row): ?>
                            <tr>
                                <td><strong><?php echo esc_html($row->name); ?></strong></td>
                                <td>
                                    <input type="text" value="<?php echo esc_url(home_url('/?linkomize_ref=' . $row->ref_code)); ?>" 
                                           readonly onclick="this.select()" 
                                           style="width: 100%; padding: 4px; border: 1px solid #ddd; border-radius: 20px; font-size: 12px;">
                                </td>
                                <td><span class="dashicons dashicons-visibility"></span> <?php echo intval($row->clicks); ?></td>
                              
                                <td>
                                  
<a 
    href="<?php echo esc_url( wp_nonce_url( admin_url('admin.php?page=linkomize&delete=' . intval($row->id) ), 'delete_template' ) ); ?>" 
    class="button button-large" 
    onclick="return confirm('Are you sure you want to delete this template?')" 
    style="color: #d63638;">
    Delete
</a>

                                </td>
                            </tr>
                            <?php endforeach; ?>
                        </tbody>
                    </table>
                </div>
            <?php endif; ?>
        </div>
    </div>
    
    <?php
}
function linkomize_show_pro_vs_free_features() {
    ?>
    <div class="linkomize-upgrade-box" style="background: rgb(224, 101, 74); border: 1px solid rgb(173, 216, 230); padding: 10px; margin-top: 20px; border-radius: 10px; box-shadow: 0 2px 6px rgba(0, 123, 255, 0.2);">
        <h2 style="margin-top: 0; color: rgb(0, 0, 0);">🔓 Free vs Pro Version</h2>
        <table class="wp-list-table widefat striped">
            <thead>
                <tr>
                    <th>Feature</th>
                    <th>Free</th>
                    <th>Pro</th>
                </tr>
            </thead>
            <tbody>
                <tr>
                    <td>Unlimited viewing link</td>
                    <td>❌</td>
                    <td>✅</td>
                </tr>
                <tr>
                    <td>Live statistics panel</td>
                    <td>❌</td>
                    <td>✅</td>
                </tr>
                <tr>
                    <td>Add to cart & purchase analytics</td>
                    <td>❌</td>
                    <td>✅</td>
                </tr>
                <tr>
                    <td>Google Ads UTM support</td>
                    <td>✅</td>
                    <td>✅</td>
                </tr>
                <tr>
                    <td>Facebook Ads & Pixel support</td>
                    <td>❌</td>
                    <td>✅</td>
                </tr>
            </tbody>
        </table>
        <p style="margin-top: 30px; font-size:15px; ">
            🔒 Unlock all features with the Pro version.<br><br>
            <a href="https://www.bermikodplugins.com/eklenti/linkomize-pro/" class="button button-primary" target="_blank" style="background: rgb(0, 123, 255); border-color: rgb(202, 204, 81);">Buy Pro Version</a>
           
        </p>
        
    </div>
    <?php
}


?>