<?php
class LTHALG_Settings {
    public function __construct() {
        add_action('admin_menu', array($this, 'add_admin_menu'));
        add_action('admin_init', array($this, 'settings_init'));
        add_action('admin_enqueue_scripts', array($this, 'enqueue_admin_scripts'));
    }

    public function enqueue_admin_scripts($hook) {
        if ('settings_page_link-to-headline-anchor-link-generator' !== $hook) {
            return;
        }

        wp_enqueue_media();
        wp_enqueue_script('lthalg-admin', LTHALG_PLUGIN_URL . 'assets/js/admin.js', array('jquery'), LTHALG_PLUGIN_VERSION, true);
    }

    public function add_admin_menu() {
        add_options_page(
            __('Anchor Link Generator', 'link-to-headline-anchor-link-generator'),
            __('Anchor Links', 'link-to-headline-anchor-link-generator'),
            'manage_options',
            'link-to-headline-anchor-link-generator',
            array($this, 'options_page')
        );
    }

    public function settings_init() {
        register_setting('lthalg_settings', 'lthalg_settings', array($this, 'sanitize_settings'));

        $page_slug = 'link-to-headline-anchor-link-generator';

        add_settings_section('lthalg_general_section', __('General Settings', 'link-to-headline-anchor-link-generator'), array($this, 'section_callback'), $page_slug);
        add_settings_field('heading_levels', __('Heading Levels', 'link-to-headline-anchor-link-generator'), array($this, 'heading_levels_render'), $page_slug, 'lthalg_general_section');
        add_settings_field('icon_type', __('Icon Type', 'link-to-headline-anchor-link-generator'), array($this, 'icon_type_render'), $page_slug, 'lthalg_general_section');
        add_settings_field('custom_icon', __('Custom Icon', 'link-to-headline-anchor-link-generator'), array($this, 'custom_icon_render'), $page_slug, 'lthalg_general_section');
        add_settings_field('icon_position', __('Icon Position', 'link-to-headline-anchor-link-generator'), array($this, 'icon_position_render'), $page_slug, 'lthalg_general_section');
        add_settings_field('show_icon', __('Show Icon', 'link-to-headline-anchor-link-generator'), array($this, 'show_icon_render'), $page_slug, 'lthalg_general_section');
        add_settings_field('sticky_header_offset', __('Sticky Header Offset', 'link-to-headline-anchor-link-generator'), array($this, 'sticky_header_offset_render'), $page_slug, 'lthalg_general_section');
        add_settings_field('excluded_ids', __('Excluded Pages/Posts', 'link-to-headline-anchor-link-generator'), array($this, 'excluded_ids_render'), $page_slug, 'lthalg_general_section');
    }

    public function sanitize_settings($input) {
        $sanitized = array();
        $options = get_option('lthalg_settings');
        
        $sanitized['heading_levels'] = isset($input['heading_levels']) && is_array($input['heading_levels']) ? array_map('sanitize_text_field', $input['heading_levels']) : ($options['heading_levels'] ?? array('h2', 'h3', 'h4'));
        $sanitized['icon_type'] = isset($input['icon_type']) && in_array($input['icon_type'], array('default', 'custom')) ? $input['icon_type'] : ($options['icon_type'] ?? 'default');
        $sanitized['custom_icon'] = isset($input['custom_icon']) ? esc_url_raw($input['custom_icon']) : ($options['custom_icon'] ?? '');
        $sanitized['icon_position'] = isset($input['icon_position']) && in_array($input['icon_position'], array('left', 'right')) ? $input['icon_position'] : ($options['icon_position'] ?? 'right');
        $sanitized['show_icon'] = isset($input['show_icon']) ? sanitize_text_field($input['show_icon']) : ($options['show_icon'] ?? 'always');
        $sanitized['sticky_header_offset'] = isset($input['sticky_header_offset']) ? absint($input['sticky_header_offset']) : ($options['sticky_header_offset'] ?? 0);
        $sanitized['excluded_ids'] = isset($input['excluded_ids']) ? sanitize_text_field($input['excluded_ids']) : ($options['excluded_ids'] ?? '');

        return $sanitized;
    }

    public function section_callback() {
        echo '<p>' . esc_html__('Configure how the anchor links should behave on your site.', 'link-to-headline-anchor-link-generator') . '</p>';
    }

    public function heading_levels_render() {
        $options = get_option('lthalg_settings');
        $levels = isset($options['heading_levels']) ? $options['heading_levels'] : array('h2', 'h3', 'h4');
        ?>
        <fieldset>
            <label><input type="checkbox" name="lthalg_settings[heading_levels][]" value="h2" <?php checked(in_array('h2', $levels)); ?>> <?php esc_html_e('H2 Headings', 'link-to-headline-anchor-link-generator'); ?></label><br>
            <label><input type="checkbox" name="lthalg_settings[heading_levels][]" value="h3" <?php checked(in_array('h3', $levels)); ?>> <?php esc_html_e('H3 Headings', 'link-to-headline-anchor-link-generator'); ?></label><br>
            <label><input type="checkbox" name="lthalg_settings[heading_levels][]" value="h4" <?php checked(in_array('h4', $levels)); ?>> <?php esc_html_e('H4 Headings', 'link-to-headline-anchor-link-generator'); ?></label>
        </fieldset>
        <?php
    }

    public function icon_type_render() {
        $options = get_option('lthalg_settings');
        $icon_type = isset($options['icon_type']) ? $options['icon_type'] : 'default';
        ?>
        <select name="lthalg_settings[icon_type]" id="lthalg_icon_type">
            <option value="default" <?php selected($icon_type, 'default'); ?>><?php esc_html_e('Default Icon (🔗)', 'link-to-headline-anchor-link-generator'); ?></option>
            <option value="custom" <?php selected($icon_type, 'custom'); ?>><?php esc_html_e('Custom Icon', 'link-to-headline-anchor-link-generator'); ?></option>
        </select>
        <?php
    }

    public function custom_icon_render() {
        $options = get_option('lthalg_settings');
        $custom_icon = isset($options['custom_icon']) ? $options['custom_icon'] : '';
        $icon_type = isset($options['icon_type']) ? $options['icon_type'] : 'default';
        $style = $icon_type !== 'custom' ? 'style="display: none;"' : '';
        ?>
        <div id="lthalg_custom_icon_wrapper" <?php echo wp_kses_post($style); ?>>
            <input type="text" name="lthalg_settings[custom_icon]" id="lthalg_custom_icon" value="<?php echo esc_attr($custom_icon); ?>" class="regular-text">
            <button type="button" class="button lthalg-media-upload" data-target="#lthalg_custom_icon"><?php esc_html_e('Upload Icon', 'link-to-headline-anchor-link-generator'); ?></button>
            <p class="description"><?php esc_html_e('Upload a custom SVG icon for the anchor links.', 'link-to-headline-anchor-link-generator'); ?></p>
            <?php if ($custom_icon) : ?>
            <div style="margin-top: 10px;">
                <img src="<?php echo esc_url($custom_icon); ?>" alt="<?php esc_attr_e('Custom Icon', 'link-to-headline-anchor-link-generator'); ?>" style="max-width: 24px; height: auto;">
            </div>
            <?php endif; ?>
        </div>
        <?php
    }

    public function icon_position_render() {
        $options = get_option('lthalg_settings');
        $position = isset($options['icon_position']) ? $options['icon_position'] : 'right';
        ?>
        <select name="lthalg_settings[icon_position]">
            <option value="right" <?php selected($position, 'right'); ?>><?php esc_html_e('Right', 'link-to-headline-anchor-link-generator'); ?></option>
            <option value="left" <?php selected($position, 'left'); ?>><?php esc_html_e('Left', 'link-to-headline-anchor-link-generator'); ?></option>
        </select>
        <p class="description"><?php esc_html_e('Choose where the anchor link icon appears relative to the heading.', 'link-to-headline-anchor-link-generator'); ?></p>
        <?php
    }
    
    
    public function show_icon_render() {
        $options = get_option('lthalg_settings');
        $show = isset($options['show_icon']) ? $options['show_icon'] : 'always';
        ?>
        <select name="lthalg_settings[show_icon]">
            <option value="always" <?php selected($show, 'always'); ?>><?php esc_html_e('Always', 'link-to-headline-anchor-link-generator'); ?></option>
            <option value="hover" <?php selected($show, 'hover'); ?>><?php esc_html_e('On Hover', 'link-to-headline-anchor-link-generator'); ?></option>
        </select>
        <p class="description"><?php esc_html_e('Control whether the icon is always visible or only shown on heading hover.', 'link-to-headline-anchor-link-generator'); ?></p>
        <?php
    }
    public function sticky_header_offset_render() {
        $options = get_option('lthalg_settings');
        $offset = isset($options['sticky_header_offset']) ? $options['sticky_header_offset'] : 0;
        ?>
        <input type="number" name="lthalg_settings[sticky_header_offset]" value="<?php echo esc_attr($offset); ?>" class="small-text">
        <p class="description"><?php esc_html_e('Set a top offset in pixels to account for sticky headers when linking to a heading.', 'link-to-headline-anchor-link-generator'); ?></p>
        <?php
    }

    public function excluded_ids_render() {
        $options = get_option('lthalg_settings');
        $excluded_ids = isset($options['excluded_ids']) ? $options['excluded_ids'] : '';
        ?>
        <input type="text" name="lthalg_settings[excluded_ids]" value="<?php echo esc_attr($excluded_ids); ?>" class="regular-text" placeholder="e.g., 12, 45, 78">
        <p class="description"><?php esc_html_e('Comma-separated list of post IDs to exclude from anchor link generation.', 'link-to-headline-anchor-link-generator'); ?></p>
        <?php
    }

    public function options_page() {
        ?>
        <div class="wrap">
            <div style="display: grid; grid-template-columns: 1fr 320px; grid-gap: 20px;">
                <div id="lthalg-main-settings">
                    <h1><?php esc_html_e('Anchor Link Generator Settings', 'link-to-headline-anchor-link-generator'); ?></h1>
                    <form action="options.php" method="post">
                        <?php
                        settings_fields('lthalg_settings');
                        do_settings_sections('link-to-headline-anchor-link-generator');
                        submit_button();
                        ?>
                    </form>
                </div>
                
                <div id="lthalg-pro-promo" style="padding-top: 28px;">
                    <div style="border: 1px solid #c3c4c7; border-left-width: 4px; border-left-color: #007cba; background: #fff; padding: 15px 20px;">
                        <h2 style="margin-top:0;"><?php esc_html_e('Upgrade to Pro', 'link-to-headline-anchor-link-generator'); ?></h2>
                        <p><?php esc_html_e('Supercharge your content navigation with our powerful Pro features!', 'link-to-headline-anchor-link-generator'); ?></p>
                        <ul style="list-style:disc; margin-left: 20px;">
                            <li><strong><?php esc_html_e('Automatic Table of Contents', 'link-to-headline-anchor-link-generator'); ?></strong></li>
                            <li><?php esc_html_e('Collapsible & Sticky TOC box', 'link-to-headline-anchor-link-generator'); ?></li>
                            <li><?php esc_html_e('Smooth Scroll & Scrollspy', 'link-to-headline-anchor-link-generator'); ?></li>
                            <li><?php esc_html_e('Support for H5 & H6 headings', 'link-to-headline-anchor-link-generator'); ?></li>
                            <li><?php esc_html_e('Shortcode for manual placement', 'link-to-headline-anchor-link-generator'); ?></li>
                            <li><?php esc_html_e('Priority Support', 'link-to-headline-anchor-link-generator'); ?></li>
                        </ul>
                        <a href="https://kudavoor.gumroad.com/l/link-to-headline-anchor-link-generator-pro" class="button button-primary" target="_blank" style="width: 100%; text-align: center; height: 40px; line-height: 38px; font-size: 16px;">
                            <?php esc_html_e('Upgrade to Pro Now', 'link-to-headline-anchor-link-generator'); ?>
                        </a>
                    </div>
                </div>
                </div>
        </div>
        <?php
    }
}