jQuery(document).ready(function($) {
    // Handle icon type change
    $('#lthalg_icon_type').change(function() {
        if ($(this).val() === 'custom') {
            $('#lthalg_custom_icon_wrapper').show();
        } else {
            $('#lthalg_custom_icon_wrapper').hide();
        }
    });

    // Media uploader
    $(document).on('click', '.lthalg-media-upload', function(e) {
        e.preventDefault();
        
        var button = $(this);
        var target = $(button.data('target'));
        
        var frame = wp.media({
            title: 'Select or Upload Icon',
            button: {
                text: 'Use this icon'
            },
            multiple: false
        });
        
        frame.on('select', function() {
            var attachment = frame.state().get('selection').first().toJSON();
            target.val(attachment.url);
            
            // Preview the icon
            var wrapper = $('#lthalg_custom_icon_wrapper');
            wrapper.find('img').remove();
            wrapper.append(
                '<div style="margin-top: 10px;"><img src="' + attachment.url + '" alt="Custom Icon" style="max-width: 24px; height: auto;"></div>'
            );
        });
        
        frame.open();
    });
});