<?php
/*
Plugin Name: Limbo
Plugin URI: https://www.uselimbo.com
Description: A WooCommerce extension to manage connections and products via a custom admin interface.
Version: 1.0.3
Author: Bruno Pastorelli
Author URI: http://brunopastorelli.com
License: GPL2
Text Domain: limbo
*/

// Exit if accessed directly
if ( ! defined( 'ABSPATH' ) ) {
    exit;
}

// Define plugin constants
define('LIMBO_VERSION', '1.0.3');
define('LIMBO_PLUGIN_FILE', __FILE__);
define('LIMBO_PLUGIN_DIR', plugin_dir_path(__FILE__));
define('LIMBO_PLUGIN_URL', plugin_dir_url(__FILE__));

// Check if WooCommerce is active
if ( ! in_array( 'woocommerce/woocommerce.php', apply_filters( 'active_plugins', get_option( 'active_plugins' ) ) ) ) {
    // WooCommerce is not active, display admin notice
    add_action( 'admin_notices', 'limbo_woocommerce_inactive_notice' );
    function limbo_woocommerce_inactive_notice() {
        echo '<div class="error"><p><strong>Limbo</strong> ' . esc_html__( 'requires WooCommerce to be installed and active.', 'limbo' ) . '</p></div>';
    }
    return;
}

// Include subpage files
require_once LIMBO_PLUGIN_DIR . 'admin/limbo-dashboard.php';
require_once LIMBO_PLUGIN_DIR . 'admin/limbo-connections/limbo-connections.php';
require_once LIMBO_PLUGIN_DIR . 'admin/new-connection/limbo-new-connection.php';
require_once LIMBO_PLUGIN_DIR . 'admin/import/limbo-import.php';
require_once LIMBO_PLUGIN_DIR . 'admin/export/limbo-export.php';
require_once LIMBO_PLUGIN_DIR . 'admin/import/limbo-import-functions.php';
require_once LIMBO_PLUGIN_DIR . 'admin/export/limbo-export-functions.php';
require_once LIMBO_PLUGIN_DIR . 'admin/new-connection/limbo-new-connection-functions.php';

// Add menu and submenus
function limbo_add_menu() {
    // Add the top-level menu page
    add_menu_page(
        esc_html__( 'Limbo', 'limbo' ),                    // Page title
        esc_html__( 'Limbo', 'limbo' ),                    // Menu title
        'manage_options',           // Capability
        'limbo',                    // Menu slug
        'limbo_display_dashboard',  // Function to display the dashboard page content
        'dashicons-cart',           // Icon URL
        56                          // Position
    );

    // Add submenu pages
    add_submenu_page(
        'limbo',                    // Parent slug
        esc_html__( 'Dashboard', 'limbo' ),                // Page title
        esc_html__( 'Dashboard', 'limbo' ),                // Menu title
        'manage_options',           // Capability
        'limbo',                    // Menu slug (same as parent to replace the default submenu)
        'limbo_display_dashboard'   // Function to display the dashboard page content
    );

    add_submenu_page(
        'limbo',
        esc_html__( 'Manage Connections', 'limbo' ),
        esc_html__( 'Manage Connections', 'limbo' ),
        'manage_options',
        'limbo-connections',
        'limbo_display_connections'
    );

    add_submenu_page(
        'limbo',
        esc_html__( 'New Connection', 'limbo' ),
        esc_html__( 'New Connection', 'limbo' ),
        'manage_options',
        'limbo-new-connection',
        'limbo_display_new_connection'
    );

    add_submenu_page(
        'limbo',
        esc_html__( 'Import Products', 'limbo' ),
        esc_html__( 'Import Products', 'limbo' ),
        'manage_options',
        'limbo-import',
        'limbo_display_import'
    );

    add_submenu_page(
        'limbo',
        esc_html__( 'Export Products', 'limbo' ),
        esc_html__( 'Export Products', 'limbo' ),
        'manage_options',
        'limbo-export',
        'limbo_display_export'
    );
}
add_action( 'admin_menu', 'limbo_add_menu' );

// Enqueue admin scripts and styles
function limbo_enqueue_admin_scripts( $hook ) {
    // Enqueue script and styles only on the Limbo admin pages
    $limbo_pages = [
        'toplevel_page_limbo',
        'limbo_page_limbo-connections',
        'limbo_page_limbo-new-connection',
        'limbo_page_limbo-import',
        'limbo_page_limbo-export',
    ];

    if ( in_array( $hook, $limbo_pages ) ) {
        wp_enqueue_style( 'limbo-admin-css', LIMBO_PLUGIN_URL . 'css/admin-style.css', array(), '1.0' );
        wp_enqueue_script( 'limbo-admin-js', LIMBO_PLUGIN_URL . 'js/admin-script.js', array( 'jquery' ), '1.0', true );
        wp_localize_script( 'limbo-admin-js', 'limboData', array(
            'welcomeMessage'       => esc_html__( 'Welcome to Your Seller Dashboard', 'limbo' ),
            'sellerWelcomeText'    => esc_html__( 'Manage your connections, import and export products with ease.', 'limbo' ),
            'buyerWelcomeText'     => esc_html__( 'You are currently logged in as a buyer. To access seller features, please log in with a seller account.', 'limbo' ),
            'loginMessage'         => esc_html__( 'Connect to your account to manage connections.', 'limbo' ),
            'loginButtonText'      => esc_html__( 'Login', 'limbo' ),
            'loginAsSellerText'    => esc_html__( 'Login as Seller', 'limbo' ),
            'manageConnectionsUrl' => admin_url( 'admin.php?page=limbo-connections' ),
            'newConnectionUrl'     => admin_url( 'admin.php?page=limbo-new-connection' ),
            'importUrl'            => admin_url( 'admin.php?page=limbo-import' ),
            'exportUrl'            => admin_url( 'admin.php?page=limbo-export' ),
            'settingsUrl'          => admin_url( 'admin.php?page=limbo-settings' ),
        ) );
    }
}
add_action( 'admin_enqueue_scripts', 'limbo_enqueue_admin_scripts' );

// Add Limbo button and modal to product page
function limbo_add_button() {
    global $product;
    if ( $product ) {
        ?>
        <!-- Limbo Button -->
        <button type="button" id="limbo-redirect-btn" class="button alt" data-product-id="<?php echo esc_attr( $product->get_id() ); ?>">
            <?php echo esc_html__( 'View on Limbo', 'limbo' ); ?>
        </button>
        
        <!-- Limbo Modal -->
        <div id="limbo-modal" class="limbo-modal">
            <div class="limbo-modal-content">
                <div class="limbo-modal-header">
                    <span class="limbo-close">&times;</span>
                </div>
                <div class="limbo-modal-body">
                    <iframe id="limbo-iframe" frameborder="0" allowfullscreen></iframe>
                </div>
            </div>
        </div>
        <?php
    }
}
add_action( 'woocommerce_after_add_to_cart_button', 'limbo_add_button' );

// Enqueue script for the button functionality
function limbo_enqueue_product_script() {
    if ( is_product() ) {
        wp_enqueue_script( 'limbo-product-script', LIMBO_PLUGIN_URL . 'js/product-page.js', array( 'jquery' ), '1.0', true );
        
        // Pass variables to JavaScript with proper sanitization
        wp_localize_script( 'limbo-product-script', 'limboData', array(
            'ajaxurl' => admin_url( 'admin-ajax.php' ),
            'shopDomain' => esc_js( sanitize_text_field( wp_unslash( isset( $_SERVER['HTTP_HOST'] ) ? $_SERVER['HTTP_HOST'] : '' ) ) ),
            'limboPublicUrl' => 'https://www.uselimbo.com/public/product/',
        ) );
    }
}
add_action( 'wp_enqueue_scripts', 'limbo_enqueue_product_script' );

function limbo_enqueue_product_styles() {
    if ( is_product() ) {
        wp_enqueue_style(
            'limbo-product-styles', 
            LIMBO_PLUGIN_URL . 'css/product-page.css',
            array(),
            '1.0.0'
        );
    }
}
add_action( 'wp_enqueue_scripts', 'limbo_enqueue_product_styles' );
