jQuery(document).ready(function($) {
    $('#limbo-redirect-btn').on('click', async function() {
        const woocommerceProductId = $(this).data('product-id');
        const shopDomain = window.location.origin;
        
        try {
            const response = await fetch('https://www.serverlimbo.com/seller/woocommerce/get-connection-by-woocommerce-product-id', {
                method: 'POST',
                headers: {
                    'Content-Type': 'application/json'
                },
                body: JSON.stringify({
                    woocommerceProductId,
                    shopDomain
                })
            });

            const data = await response.json();
            
            if (data.success && data.connection && data.connection.limboProductId) {
                // Open popup window
                const width = 500;
                const height = 600;
                const left = (window.screen.width / 2) - (width / 2);
                const top = (window.screen.height / 2) - (height / 2);
                
                window.open(
                    limboData.limboPublicUrl + data.connection.limboProductId,
                    'LimboProduct',
                    `width=${width},height=${height},top=${top},left=${left},resizable=yes,scrollbars=yes`
                );
            } else {
                console.error('Failed to get Limbo product ID:', data.message);
                alert(data.message || 'No connection found for this product.');
            }
        } catch (error) {
            console.error('Error:', error);
            alert('Failed to connect to Limbo. Please try again later.');
        }
    });
}); 