(function($) {
    $(document).ready(function() {
        fetchUserData();
    });

    function fetchUserData() {
        $.ajax({
            url: 'https://www.limbocookiejar.com/get-user-data',
            method: 'GET',
            xhrFields: {
                withCredentials: true
            },
            success: function(response) {
                console.log('User data response:', response);
                if (response && response.userData) {
                    localStorage.setItem('limboUserData', JSON.stringify(response.userData));
                    var userData = response.userData;
                    if (userData.userType === 'seller') {
                        // User is a seller; display seller dashboard
                        displaySellerDashboard(userData);
                    } else if (userData.userType === 'buyer') {
                        // User is a buyer; display buyer message with login as seller button
                        displayBuyerMessage(userData);
                    } else {
                        // Unknown userType; display login message
                        displayLoginMessage();
                    }
                } else {
                    // No user data; display login message
                    displayLoginMessage();
                }
            },
            error: function(xhr, status, error) {
                console.error('Error fetching user data:', error);
                displayLoginMessage();
            }
        });
    }

    function displaySellerDashboard(userData) {
        console.log('Displaying seller dashboard for:', userData);

        var cards = [
            {
                title: 'Manage Connections',
                url: limboData.manageConnectionsUrl,
                description: 'Manage your existing connections',
            },
            {
                title: 'New Connection',
                url: limboData.newConnectionUrl,
                description: 'Create a new connection',
            },
            {
                title: 'Import Products',
                url: limboData.importUrl,
                description: 'Import products to your store',
            },
            {
                title: 'Export Products',
                url: limboData.exportUrl,
                description: 'Export products from your store',
            },
        ];

        var cardHtml = '';
        cards.forEach(function(card) {
            cardHtml += `
                <div class="limbo-card">
                    <h3>${card.title}</h3>
                    <p>${card.description}</p>
                    <a href="${card.url}" class="button">${'Learn More'}</a>
                </div>
            `;
        });

        var html = `
            <div class="limbo-dashboard">
                <h2>${limboData.welcomeMessage}, ${userData.name}</h2>
                <p>${limboData.sellerWelcomeText}</p>
                <div class="limbo-card-container">
                    ${cardHtml}
                </div>
            </div>
        `;
        $('.limbo-user-info').html(html);
    }

    function displayBuyerMessage(userData) {
        console.log('Displaying buyer message for:', userData);
        var html = `
            <div class="limbo-buyer-message">
                <h2>${'Welcome to LIMBO, '}${userData.name}</h2>
                <p>${limboData.buyerWelcomeText}</p>
                <button id="limbo-login-button" class="button button-primary">${limboData.loginAsSellerText}</button>
            </div>
        `;
        $('.limbo-user-info').html(html);
        $('#limbo-login-button').on('click', function() {
            openLoginPopup();
        });
    }

    function displayLoginMessage() {
        console.log('Displaying login message');
        var html = `
            <div class="limbo-login-message">
                <h2>${'Welcome to LIMBO'}</h2>
                <p>${limboData.loginMessage}</p>
                <button id="limbo-login-button" class="button button-primary">${limboData.loginButtonText}</button>
            </div>
        `;
        $('.limbo-user-info').html(html);
        $('#limbo-login-button').on('click', function() {
            openLoginPopup();
        });
    }

    function openLoginPopup() {
        var width = 500;
        var height = 600;
        var left = (screen.width / 2) - (width / 2);
        var top = (screen.height / 2) - (height / 2);
        var popup = window.open('https://serverlimbo.com/seller/auth/google', 'LimboLogin', `width=${width},height=${height},top=${top},left=${left}`);

        var checkPopupClosed = setInterval(function() {
            if (popup.closed) {
                clearInterval(checkPopupClosed);
                fetchUserData();
            }
        }, 500);
    }
})(jQuery);
