<?php
// Exit if accessed directly
if (!defined('ABSPATH')) {
    exit;
}

function limbo_display_new_connection() {
    // Enqueue necessary scripts and styles
    wp_enqueue_style(
        'limbo-new-connection-css', 
        LIMBO_PLUGIN_URL . 'admin/new-connection/css/limbo-new-connection.css',
        array(),
        LIMBO_VERSION
    );
    wp_enqueue_script('limbo-new-connection-js', LIMBO_PLUGIN_URL . 'admin/new-connection/js/limbo-new-connection.js', array('jquery'), LIMBO_VERSION, true);

    // Add nonce and localization
    wp_localize_script('limbo-new-connection-js', 'limboNewConnection', array(
        'ajaxurl' => admin_url('admin-ajax.php'),
        'nonce' => wp_create_nonce('limbo-new-connection-nonce'),
        'strings' => array(
            'networkError' => __('Network response was not ok', 'limbo'),
            'loadError' => __('Error loading products. Please try again later.', 'limbo'),
            'noProductsFound' => __('No products found.', 'limbo'),
            'createConnection' => __('Create Connection', 'limbo'),
            'creating' => __('Creating Connection...', 'limbo'),
            'connectionSuccess' => __('Connection created successfully!', 'limbo'),
            'connectionError' => __('Failed to create connection. Please try again.', 'limbo'),
            'noUserData' => __('Please log in to create a connection.', 'limbo'),
            'invalidUserData' => __('Invalid user data. Please log in again.', 'limbo')
        )
    ));
    ?>
    <div class="wrap">
        <h1><?php esc_html_e('Create New Connection', 'limbo'); ?></h1>
        
        <div class="connection-container">
            <!-- WooCommerce Products -->
            <div class="product-list-container">
                <h2><?php esc_html_e('WooCommerce Products', 'limbo'); ?></h2>
                <div class="search-container">
                    <input type="text" 
                           id="wc-product-search" 
                           placeholder="<?php esc_attr_e('Search WooCommerce products...', 'limbo'); ?>"
                    >
                </div>
                <div id="wc-products-list" class="products-list">
                    <!-- Products will be loaded here -->
                </div>
            </div>

            <!-- Limbo Products -->
            <div class="product-list-container">
                <h2><?php esc_html_e('Limbo Products', 'limbo'); ?></h2>
                <div class="search-container">
                    <input type="text" 
                           id="limbo-product-search" 
                           placeholder="<?php esc_attr_e('Search Limbo products...', 'limbo'); ?>"
                    >
                </div>
                <div id="limbo-products-list" class="products-list">
                    <!-- Products will be loaded here -->
                </div>
            </div>
        </div>
    </div>
    <?php
}
