<?php
// Exit if accessed directly
if (!defined('ABSPATH')) {
    exit;
}

// AJAX handler for fetching WooCommerce products
function limbo_new_connection_get_wc_products() {
    // Verify nonce
    check_ajax_referer('limbo-new-connection-nonce', 'security');

    // Check user capabilities
    if (!current_user_can('manage_options')) {
        wp_send_json_error('Unauthorized access');
        return;
    }

    // Query WooCommerce products
    $args = array(
        'post_type' => 'product',
        'post_status' => 'publish',
        'posts_per_page' => -1
    );

    $products = array();
    $query = new WP_Query($args);

    if ($query->have_posts()) {
        while ($query->have_posts()) {
            $query->the_post();
            $product = wc_get_product(get_the_ID());
            
            $products[] = array(
                'id' => $product->get_id(),
                'name' => $product->get_name(),
                'price' => $product->get_price_html(),
                'images' => array_map(function($image_id) {
                    return array(
                        'full' => wp_get_attachment_image_url($image_id, 'full'),
                        'thumbnail' => wp_get_attachment_image_url($image_id, 'thumbnail')
                    );
                }, $product->get_gallery_image_ids())
            );
        }
        wp_reset_postdata();
    }

    wp_send_json_success($products);
}
add_action('wp_ajax_limbo_new_connection_get_wc_products', 'limbo_new_connection_get_wc_products');