<?php
// Exit if accessed directly
if ( ! defined( 'ABSPATH' ) ) {
    exit;
}

// Dashboard Page Callback Function
function limbo_display_dashboard() {
    // Enqueue styles with version
    wp_enqueue_style(
        'limbo-dashboard-styles', 
        plugins_url('css/limbo-dashboard.css', dirname(__FILE__)),
        array(),
        LIMBO_VERSION
    );

    // Enqueue admin script
    wp_enqueue_script(
        'limbo-admin-script',
        plugins_url('js/admin-script.js', dirname(__FILE__)),
        array('jquery'),
        LIMBO_VERSION,
        true
    );

    // Localize script
    wp_localize_script(
        'limbo-admin-script',
        'limboData',
        array(
            'welcomeMessage' => esc_html__('Welcome to Your Seller Dashboard', 'limbo'),
            'sellerWelcomeText' => esc_html__('Manage your connections, import and export products with ease.', 'limbo'),
            'buyerWelcomeText' => esc_html__('You are currently logged in as a buyer. To access seller features, please log in with a seller account.', 'limbo'),
            'loginMessage' => esc_html__('Connect to your account to manage connections.', 'limbo'),
            'loginButtonText' => esc_html__('Login', 'limbo'),
            'loginAsSellerText' => esc_html__('Login as Seller', 'limbo'),
            'manageConnectionsUrl' => admin_url('admin.php?page=limbo-connections'),
            'newConnectionUrl' => admin_url('admin.php?page=limbo-new-connection'),
            'importUrl' => admin_url('admin.php?page=limbo-import'),
            'exportUrl' => admin_url('admin.php?page=limbo-export')
        )
    );
    ?>
    <div class="wrap">
        <h1><?php esc_html_e('Home', 'limbo'); ?></h1>
        <div id="limbo-dashboard-content">
            <div class="limbo-user-info">
                <!-- Content will be populated by JavaScript -->
            </div>
        </div>
    </div>
    <?php
}
