<?php
/**
 * Limbo Import Page
 *
 * @package Limbo
 */

// Exit if accessed directly
if (!defined('ABSPATH')) {
    exit;
}

/**
 * Display the import products page
 */
function limbo_display_import() {
    // Check user capabilities
    if (!current_user_can('manage_woocommerce')) {
        wp_die(esc_html__('You do not have sufficient permissions to access this page.', 'limbo'));
    }

    // Enqueue required scripts and styles
    wp_enqueue_style(
        'limbo-import-styles', 
        plugins_url('css/limbo-import.css', __FILE__),
        array(),
        LIMBO_VERSION
    );

    wp_enqueue_script(
        'limbo-import-script',
        plugins_url('js/limbo-import.js', __FILE__),
        array('jquery'),
        LIMBO_VERSION,
        true
    );

    // Localize script with necessary data
    wp_localize_script('limbo-import-script', 'limboImportData', array(
        'ajaxurl' => admin_url('admin-ajax.php'),
        'nonce' => wp_create_nonce('limbo-import-nonce'),
        'pluginUrl' => plugins_url('', dirname(__FILE__))
    ));

    ?>
    <div class="wrap">
        <h1><?php esc_html_e('Import Products', 'limbo'); ?></h1>
        <div id="limbo-import-content">
            <p><?php esc_html_e('Select the products you want to import to your store.', 'limbo'); ?></p>
            
            <!-- Search Bar -->
            <div class="search-container">
                <input type="text" 
                       id="product-search" 
                       placeholder="<?php echo esc_attr__('Search products...', 'limbo'); ?>">
            </div>

            <!-- Products Display Section -->
            <div id="products-display">
                <div class="section-header">
                    <h2 class="section-title"><?php esc_html_e('Your Products', 'limbo'); ?></h2>
                    <button id="select-all" class="button">
                        <?php esc_html_e('Select All Products', 'limbo'); ?>
                    </button>
                </div>
                <div id="products-list"></div>
                <div class="pagination-controls">
                    <button id="prev-page" class="button" disabled><?php esc_html_e('Previous', 'limbo'); ?></button>
                    <span id="page-info"></span>
                    <button id="next-page" class="button" disabled><?php esc_html_e('Next', 'limbo'); ?></button>
                </div>
                <div class="import-controls">
                    <span id="selected-count">0 products selected</span>
                    <button id="import-selected" class="button button-primary" disabled>
                        <?php esc_html_e('Import Selected Products', 'limbo'); ?>
                    </button>
                </div>
            </div>
        </div>
    </div>
    <?php
}
