<?php
// Exit if accessed directly
if (!defined('ABSPATH')) {
    exit;
}

// Add assets enqueue function
function limbo_enqueue_export_assets() {
    $screen = get_current_screen();
    if ($screen->id !== 'limbo_page_limbo-export') {
        return;
    }

    // Enqueue CSS
    wp_enqueue_style(
        'limbo-export-styles',
        LIMBO_PLUGIN_URL . 'admin/export/css/limbo-export.css',
        array(),
        LIMBO_VERSION
    );

    // Enqueue JavaScript
    wp_enqueue_script(
        'limbo-export-script',
        LIMBO_PLUGIN_URL . 'admin/export/js/limbo-export.js',
        array('jquery'),
        LIMBO_VERSION,
        true
    );

    // Localize script with translated strings and data
    wp_localize_script('limbo-export-script', 'limboExportData', array(
        'ajaxurl' => admin_url('admin-ajax.php'),
        'nonce' => wp_create_nonce('limbo-export-nonce'),
        'strings' => array(
            'selectAll' => __('Select All Products', 'limbo'),
            'unselectAll' => __('Unselect All Products', 'limbo'),
            'exporting' => __('Exporting...', 'limbo'),
            'exportSelected' => __('Export Selected Products', 'limbo'),
            'selectAtLeastOne' => __('Please select at least one product to export.', 'limbo'),
            'exportSuccess' => __('Products exported successfully to Limbo!', 'limbo'),
            'exportFailed' => __('Failed to export products:', 'limbo'),
            'noProducts' => __('No products found.', 'limbo'),
            'productsSelected' => __('products selected', 'limbo'),
            'networkError' => __('Network response was not ok', 'limbo'),
            'loadError' => __('Error loading products. Please try again later.', 'limbo'),
            'formatError' => __('Failed to format products', 'limbo'),
            'noProductsFormatted' => __('No products were formatted for export', 'limbo'),
            'exportFailedLimbo' => __('Failed to export products to Limbo', 'limbo')
        ),
        'placeholderImage' => LIMBO_PLUGIN_URL . 'assets/images/placeholder.png',
        'apiEndpoint' => 'https://www.serverlimbo.com/seller/woocommerce/create-limbo-products',
        'itemsPerPage' => 10
    ));
}
add_action('admin_enqueue_scripts', 'limbo_enqueue_export_assets');

// Export Products Page Callback Function
function limbo_display_export() {
    ?>
    <div class="wrap">
        <h1><?php esc_html_e('Export Products', 'limbo'); ?></h1>

        <div class="limbo-export-wrapper">
            <p class="description">
                <?php esc_html_e('Select the products you want to export to Limbo.', 'limbo'); ?>
            </p>

            <div class="search-container">
                <input type="text"
                       id="product-search"
                       placeholder="<?php esc_attr_e('Search products by name...', 'limbo'); ?>"
                >
            </div>

            <div id="products-display">
                <div class="section-header">
                    <h2 class="section-title"><?php esc_html_e('Your WooCommerce Products', 'limbo'); ?></h2>
                    <button id="select-all" class="button">
                        <?php esc_html_e('Select All Products', 'limbo'); ?>
                    </button>
                </div>

                <div id="products-list">
                    <!-- Products will be loaded here -->
                </div>

                <div class="pagination-controls">
                    <button id="prev-page" class="button" disabled>
                        <?php esc_html_e('Previous', 'limbo'); ?>
                    </button>
                    <span id="page-info"></span>
                    <button id="next-page" class="button" disabled>
                        <?php esc_html_e('Next', 'limbo'); ?>
                    </button>
                </div>

                <div class="export-controls">
                    <span id="selected-count">0 <?php esc_html_e('products selected', 'limbo'); ?></span>
                    <button id="export-selected" class="button button-primary" disabled>
                        <?php esc_html_e('Export Selected Products', 'limbo'); ?>
                    </button>
                </div>
            </div>
        </div>
    </div>
    <?php
}
