<?php

/**
 * Fired when the plugin is uninstalled.
 *
 * When populating this file, consider the following flow
 * of control:
 *
 * - This method should be static
 * - Check if the $_REQUEST content actually is the plugin name
 * - Run an admin referrer check to make sure it goes through authentication
 * - Verify the output of $_GET makes sense
 * - Repeat with other user roles. Best directly by using the links/query string parameters.
 * - Repeat things for multisite. Once for a single site in the network, once sitewide.
 *
 * This file may be updated more in future version of the Boilerplate; however, this is the
 * general skeleton and outline for how the file should work.
 *
 * For more information, see the following discussion:
 * https://github.com/tommcfarlin/WordPress-Plugin-Boilerplate/pull/123#issuecomment-28541913
 *
 * @link       https://wpaichatbot.com
 * @since      1.0.0
 *
 * @package    Limb_Chatbot
 */

// If uninstall not called from WordPress, then exit.
if ( ! defined( 'WP_UNINSTALL_PLUGIN' ) ) {
	exit;
}
// To load the dependencies
require plugin_dir_path( __FILE__ ) . 'includes/class-lbaic.php';
$limb_chatbot = Limb_Chatbot\Includes\Limb_Chatbot::get_instance();

// Only delete data if the "remove plugin data on uninstall" setting is explicitly enabled
if ( get_option( 'lbaic.plugin.remove_plugin_data', false ) ) {
	try {
		// Get the data deletion service instance and delete all plugin data
		$deletion_service = \Limb_Chatbot\Includes\Services\Data_Deletion_Service::instance();
		$deletion_service->delete_all_data();
	} catch ( Exception $e ) {
		// Log error but don't fail silently - let WordPress know
		error_log( 'Limb Chatbot uninstall error: ' . $e->getMessage() );
	}
}
