<?php

namespace Limb_Chatbot\Includes\Widgets\Items;


/**
 * Class Widget_Items
 *
 * Provides a registry of available widget item types.
 *
 * @since 1.0.0
 */
class Widget_Items {

	/**
	 * Get the available widget item types.
	 *
	 * Returns an associative array where keys are widget type constants and values are the respective class names.
	 *
	 * @return array<string, string> Array of widget type constants to class names.
	 * @since 1.0.0
	 */
	public static function get_types(): array {
		return apply_filters( 'lbaic_widget_items', [
			Prompt_Widget_Item::TYPE       => Prompt_Widget_Item::class,
			Message_Widget_Item::TYPE      => Message_Widget_Item::class,
			Chat_History_Widget_Item::TYPE => Chat_History_Widget_Item::class,
			Link_Widget_Item::TYPE         => Link_Widget_Item::class,
			Text_Widget_Item::TYPE         => Text_Widget_Item::class,
			Lead_Capture_Widget_Item::TYPE => Lead_Capture_Widget_Item::class,
		] );
	}
}