<?php

namespace Limb_Chatbot\Includes\Widgets\Items;

/**
 * Class Text_Widget_Item
 *
 * Represents a text widget item that displays rich text content.
 *
 * @since 1.0.11
 */
class Text_Widget_Item extends Widget_Item {

	/**
	 * Widget type identifier.
	 *
	 * @var string
	 * @since 1.0.11
	 */
	const TYPE = 'text';

	/**
	 * Widget item type.
	 *
	 * @var string
	 * @since 1.0.11
	 */
	public string $type = self::TYPE;

	/**
	 * Get the text content.
	 *
	 * Returns the HTML content stored in the data array.
	 *
	 * @return string The text content, defaults to empty string if none.
	 * @since 1.0.11
	 */
	public function get_content(): string {
		return $this->data['content'] ?? '';
	}
}
