<?php

namespace Limb_Chatbot\Includes\Widgets\Items;

/**
 * Class Message_Widget_Item
 *
 * Represents a message widget item.
 *
 * @since 1.0.0
 */
class Message_Widget_Item extends Widget_Item {

	/**
	 * Widget type identifier.
	 *
	 * @var string
	 * @since 1.0.0
	 */
	const TYPE = 'message';

	/**
	 * Widget item type.
	 *
	 * @var string
	 * @since 1.0.0
	 */
	public string $type = self::TYPE;

	/**
	 * List of suggestion strings related to the message.
	 *
	 * @var array<string>
	 * @since 1.0.0
	 */
	public array $suggestions = [];

	/**
	 * Whether the item should notify about messages.
	 *
	 * @var bool
	 * @since 1.0.11
	 */
	public bool $notify = false;

	/**
	 * Widget should appear after this number of seconds.
	 *
	 * @var int
	 * @since 1.0.14
	 */
	public int $appear_after = 0;

	/**
	 * Get content array of the message.
	 *
	 * @return array The content data, defaults to empty array if none.
	 * @since 1.0.0
	 */
	public function get_content(): array {
		return $this->data['content'] ?? [];
	}
}