<?php

namespace Limb_Chatbot\Includes\Widgets\Items;

/**
 * Lead Capture Widget Item
 *
 * Represents a lead capture form widget for collecting user information.
 *
 * @since 1.0.11
 */
class Lead_Capture_Widget_Item extends Widget_Item {

	const TYPE = 'lead_capture';

	/**
	 * Widget type.
	 *
	 * @var string
	 * @since 1.0.11
	 */
	public string $type = self::TYPE;

	/**
	 * Get widget heading.
	 *
	 * @return string
	 * @since 1.0.11
	 */
	public function get_heading(): string {
		return $this->data['heading'] ?? '';
	}

	/**
	 * Get widget description.
	 *
	 * @return string
	 * @since 1.0.11
	 */
	public function get_description(): string {
		return $this->data['description'] ?? '';
	}

	/**
	 * Get submit button text.
	 *
	 * @return string
	 * @since 1.0.11
	 */
	public function get_submit_button_text(): string {
		return $this->data['submit_button_text'] ?? 'Submit';
	}

	/**
	 * Get form fields.
	 *
	 * @return array
	 * @since 1.0.11
	 */
	public function get_fields(): array {
		return $this->data['fields'] ?? [];
	}

	/**
	 * Get field by key.
	 *
	 * @param string $field_name Field name to retrieve.
	 *
	 * @return array|null Field data or null if not found.
	 * @since 1.0.11
	 */
	public function get_field( string $field_name ): ?array {
		$fields = $this->get_fields();

		foreach ( $fields as $field ) {
			if ( isset( $field['label'] ) && $field['label'] === $field_name ) {
				return $field;
			}
		}

		return null;
	}

	/**
	 * Check if field is required.
	 *
	 * @param string $field_name Field name to check.
	 *
	 * @return bool
	 * @since 1.0.11
	 */
	public function is_field_required( string $field_name ): bool {
		$field = $this->get_field( $field_name );

		return $field && $field['required'] === true;
	}

	/**
	 * Get visible fields only.
	 *
	 * @return array
	 * @since 1.0.11
	 */
	public function get_visible_fields(): array {
		// Return all fields since show property has been removed
		return $this->get_fields();
	}
}
