<?php

namespace Limb_Chatbot\Includes\Widgets\Callbacks;

use Limb_Chatbot\Includes\Data_Objects\Chatbot;

/**
 * Widget Callback Interface
 *
 * Defines the contract for widget callback implementations.
 *
 * @since 1.0.11
 */
interface Widget_Callback_Interface {

	/**
	 * Execute the widget callback.
	 *
	 * @param mixed   $widget_item Widget item instance.
	 * @param array   $params      Form parameters/collected data.
	 * @param Chatbot $chatbot     Chatbot instance.
	 *
	 * @return array Response data.
	 * @since 1.0.11
	 */
	public function execute( $widget_item, array $params, Chatbot $chatbot ): array;
}
