<?php

namespace Limb_Chatbot\Includes\Vector_Dbs\Pinecone\Services;

use Limb_Chatbot\Includes\Vector_Dbs\Pinecone\Endpoints\Pinecone_Endpoint;


/**
 * Service for authenticating Pinecone API access.
 *
 * @since 1.0.0
 */
class Auth_Service {

	/**
	 * Checks if the provided API key is valid by attempting to fetch indexes.
	 *
	 * @param array<string, mixed> $params Array of parameters, expects 'api_key' key with API key string.
	 *
	 * @return bool True if API key is valid (not 401 or 403 response), false otherwise.
	 *
	 * @since 1.0.0
	 */
	public function check_auth( $params ) {
		$api_key = ! empty( $params['api_key'] ) ? $params['api_key'] : '';
		if ( empty( $api_key ) ) {
			return false;
		}
		$response    = wp_remote_get( Pinecone_Endpoint::API_BASE_URL . 'indexes', array(
			'headers' => array(
				'Api-Key' => $api_key,
			)
		) );
		$status_code = wp_remote_retrieve_response_code( $response );

		return $status_code !== 401 && $status_code !== 403;
	}
}