<?php

namespace Limb_Chatbot\Includes\Vector_Dbs\Pinecone;

use Limb_Chatbot\Includes\Config_Dependent_Interface;
use Limb_Chatbot\Includes\Data_Objects\Config;
use Limb_Chatbot\Includes\Vector_Dbs\Pinecone\Services\Auth_Service;
use Limb_Chatbot\Includes\Vector_Dbs\Vector_Db;


/**
 * Class Pinecone
 *
 * Pinecone vector database implementation.
 *
 * @since 1.0.0
 */
class Pinecone extends Vector_Db implements Config_Dependent_Interface {

	/**
	 * Identifier for this vector DB.
	 *
	 * @var string
	 * @since 1.0.0
	 */
	static string $id = 'pinecone';

	/**
	 * Validate the given configuration by checking authentication.
	 *
	 * @param Config $config Config object to validate.
	 *
	 * @return bool True if config is valid and authorized, false otherwise.
	 *
	 * @since 1.0.0
	 */
	public function is_valid_config( Config $config ): bool {
		return ( new Auth_Service() )->check_auth( $config->get_params() );
	}
}