<?php

namespace Limb_Chatbot\Includes\Vector_Dbs;

use Limb_Chatbot\Includes\Utilities\Utility;
use Limb_Chatbot\Includes\Services\Helper;


/**
 * Class Vector_Db
 *
 * Base class for vector database implementations.
 *
 * @since 1.0.0
 */
class Vector_Db {

	/**
	 * Generates a random index name.
	 *
	 * @param string $key Optional key to include in the name. Default 'index'.
	 *
	 * @return string Generated random index name.
	 *
	 * @since 1.0.0
	 */
	public function get_random_index_name( $key = 'index' ) {
		return ucfirst( Helper::get_class_shortname( self::class ) ) . '-' . $key . '-' . Helper::get_random_string();
	}

	/**
	 * Returns the unique identifier of the vector DB implementation.
	 *
	 * @return string Static class property `$id`.
	 *
	 * @since 1.0.0
	 */
	public function get_id(): string {
		return static::$id;
	}

	/**
	 * Returns the corresponding utility class instance for the provided utility.
	 *
	 * @param Utility $utility Utility instance to get matching utility for.
	 *
	 * @return object|null Instance of the utility class or null if not found.
	 *
	 * @since 1.0.0
	 */
	public function get_utility( Utility $utility ) {
		$classname = Helper::get_namespace_name( static::class ) . '\\Utilities\\' . Helper::get_class_shortname( $utility );

		return class_exists( $classname ) ? new $classname( $utility ) : null;
	}
}