<?php

namespace Limb_Chatbot\Includes\Traits;


/**
 * Trait SingletonTrait
 *
 * Implements the Singleton design pattern for a class.
 *
 * Ensures that only one instance of the class exists and provides
 * a global access point to it.
 *
 * @since 1.0.0
 */
trait SingletonTrait {


	/**
	 * The single instance of the class.
	 *
	 * @var static|null
	 * @since 1.0.0
	 */
	protected static $instance = null;

	/**
	 * Constructor.
	 *
	 * Protected or public to allow child classes to initialize.
	 *
	 * @return void
	 * @since 1.0.0
	 */
	public function __construct() {}

	/**
	 * Returns the single instance of the class.
	 *
	 * Creates the instance if it doesn't exist.
	 *
	 * @return static The singleton instance of the class.
	 * @since 1.0.0
	 */
	final public static function instance() {
		if ( null === static::$instance ) {
			static::$instance = new static();
		}
		return static::$instance;
	}

	/**
	 * Prevents cloning the instance.
	 *
	 * @return void
	 * @since 1.0.0
	 */
	private function __clone() {}

	/**
	 * Prevents unserializing the instance.
	 *
	 * @return void
	 * @since 1.0.0
	 */
	final public function __wakeup() {
		_doing_it_wrong( __FUNCTION__, __( 'Unserializing instances of this class is forbidden.', 'limb-chatbot' ), '4.6' );
		die();
	}
}
