<?php

namespace Limb_Chatbot\Includes\Services\System_Message;

use Limb_Chatbot\Includes\Services\System_Message_Generators\Chatbot_System_Message;
use Limb_Chatbot\Includes\Utilities\Chatbot_Utility;

/**
 * Generates the system message for a chatbot based on its profile and knowledge base.
 *
 * @since 1.0.0
 */
class Chatbot_System_Message_Generator {

	/**
	 * Constructor.
	 *
	 * @since 1.0.0
	 */
	public function __construct() {
		// No dependencies needed
	}

	/**
	 * Generates the internal system message string by combining the chatbot profile system message
	 * and additional context instructions if a knowledge base is present.
	 *
	 * @param  Chatbot_Utility  $chatbot_utility  The chatbot utility instance.
	 * @param  array  $knowledge  Array of knowledge entries to inject into the system message.
	 *
	 * @return string|null The generated system message, or null if none.
	 * @since 1.0.0
	 */
	public function generate( Chatbot_Utility $chatbot_utility, array $knowledge = [] ): ?string {
		// Use the system message generator factory to get the appropriate generator based on profile
		$system_message_generator = new Chatbot_System_Message( $chatbot_utility->chatbot );
		$system_message           = $system_message_generator->generate( $chatbot_utility, $knowledge );

		return apply_filters( 'lbaic_internal_system_message', $system_message );
	}
}
