<?php

namespace Limb_Chatbot\Includes\Services\Knowledge\Source_Validators;

use Limb_Chatbot\Includes\Exceptions\Error_Codes;
use Limb_Chatbot\Includes\Exceptions\Exception;
use Limb_Chatbot\Includes\Interfaces\Source_Validator_Interface;

class Text_Validator implements Source_Validator_Interface {

	/**
	 * The count of items during manual source.
	 *
	 * @since 1.0.0
	 */
	const TEXT_KNOWLEDGE_TOTAL = 1;

	public function validate( array $config ): void {
		$text_knowledge = $config['text'] ?? null;
		if ( empty( $text_knowledge ) ) {
			throw new Exception( Error_Codes::VALIDATION_INVALID_VALUE, __( 'text knowledge is missing.', 'limb-chatbot' ) );
		}
		if ( empty( $text_knowledge['title'] ) ) {
			throw new Exception( Error_Codes::VALIDATION_INVALID_VALUE, __( 'text knowledge title is missing.', 'limb-chatbot' ) );
		}
		if ( empty( $text_knowledge['content'] ) ) {
			throw new Exception( Error_Codes::VALIDATION_INVALID_VALUE, __( 'text knowledge content is missing.', 'limb-chatbot' ) );
		}
	}

	/**
	 * Gets the total number of text knowledge items.
	 *
	 * Since text knowledge consists of a single item, this method always returns 1.
	 *
	 * @param  array  $config
	 *
	 * @return int Total number of text knowledge items.
	 *
	 * @since 1.0.9
	 */
	public function get_total( array $config ): int {
		return self::TEXT_KNOWLEDGE_TOTAL;
	}
}