<?php

namespace Limb_Chatbot\Includes\Services\Knowledge\Source_Validators;

use Limb_Chatbot\Includes\Exceptions\Error_Codes;
use Limb_Chatbot\Includes\Exceptions\Exception;
use Limb_Chatbot\Includes\Interfaces\Source_Validator_Interface;

class Manual_Validator implements Source_Validator_Interface {

	/**
	 * The count of items during manual source.
	 *
	 * @since 1.0.0
	 */
	const QA_KNOWLEDGE_TOTAL = 1;

	/**
	 * Validates the parameters for manual knowledge datasets.
	 *
	 * Ensures that manual knowledge, its input title, and output content exist.
	 *
	 * @param  array  $config  Configuration array containing manual knowledge data.
	 *
	 * @throws Exception If any required manual knowledge field is missing.
	 *
	 * @since 1.0.0
	 */
	public function validate( array $config ): void {
		$manual_knowledge = $config['q_a'] ?? null;
		if ( empty( $manual_knowledge ) ) {
			throw new Exception( Error_Codes::VALIDATION_INVALID_VALUE,
				__( 'Manual knowledge is missing.', 'limb-chatbot' ) );
		}
		if ( empty( $manual_knowledge['input'] ) ) {
			throw new Exception( Error_Codes::VALIDATION_INVALID_VALUE,
				__( 'Manual knowledge title is missing.', 'limb-chatbot' ) );
		}
		if ( empty( $manual_knowledge['output'] ) ) {
			throw new Exception( Error_Codes::VALIDATION_INVALID_VALUE,
				__( 'Manual knowledge content is missing.', 'limb-chatbot' ) );
		}
	}

	/**
	 * Gets the total number of manual knowledge items.
	 *
	 * Since manual knowledge consists of a single item, this method always returns 1.
	 *
	 * @param  array  $config
	 *
	 * @return int Total number of manual knowledge items.
	 *
	 * @since 1.0.0
	 */
	public function get_total( array $config ): int {
		return self::QA_KNOWLEDGE_TOTAL;
	}
}