<?php

namespace Limb_Chatbot\Includes\Services\Knowledge\Source_Object_Fetchers;

use Limb_Chatbot\Includes\Data_Objects\Dataset;
use Limb_Chatbot\Includes\Interfaces\Source_Fetcher_Interface;

/**
 * Class Manual_Source_Fetcher
 *
 * Fetches dataset entries for manually defined knowledge sources.
 *
 * Implements the Source_Fetcher_Interface contract to provide
 * a consistent dataset entry structure.
 *
 * @package Limb_Chatbot\Includes\Services\Knowledge\Source_Object_Fetchers
 * @since 1.0.0
 */
class Manual_Source_Fetcher implements Source_Fetcher_Interface {
	public function fetch( array $item, array $config ): array {
		return array(
			array(
				'source'          => null,
				'source_type'     => Dataset::SOURCE_QA,
				'source_sub_type' => null,
			)
		);
	}
}
