<?php

namespace Limb_Chatbot\Includes\Services\Knowledge\Source_Object_Fetchers;

use Limb_Chatbot\Includes\Interfaces\Source_Fetcher_Interface;

class CPT_Source_Fetcher implements Source_Fetcher_Interface {
	public function fetch( array $item, array $config ): array {
		$post_type      = $config['post_type'];
		$limit          = $config['limit'];

		$args = [
			'post_type'      => $post_type,
			'posts_per_page' => $item['per_page'],
			'paged'          => $item['paged'],
			'fields'         => 'ids',
			'orderby'        => 'date',
			'order'          => 'DESC'
		];

		if ( is_array( $limit ) ) {
			$args['post__in'] = $limit;
		}

		$ids    = get_posts( $args );
		$result = [];
		foreach ( $ids as $id ) {
			$result[] = [
				'source'          => $id,
				'source_type'     => 'cpt',
				'source_sub_type' => $post_type,
			];
		}

		return $result;
	}
}

