<?php

namespace Limb_Chatbot\Includes\Services\Knowledge\Knowledge_Mappers;

use Limb_Chatbot\Includes\Interfaces\Knowledge_Mapper_Interface;

class Text_Knowledge_Mapper implements Knowledge_Mapper_Interface {

	/**
	 * Generate the dataset entry input from a manual knowledge array.
	 *
	 * Returns the 'input' key trimmed for clean usage in dataset entries.
	 *
	 * @param  mixed  $object  The source object, expected to be an array with 'input' key.
	 *
	 * @return string         The dataset input, or an empty string if invalid.
	 *
	 * @since 1.0.1
	 */
	public function get_entry_input( $object ): string {
		if ( empty( $object ) || ! is_array( $object ) ) {
			return '';
		}

		return trim( $object['title'] );
	}

	/**
	 * Generate the dataset output content from a manual knowledge array.
	 *
	 * Normalizes line breaks and collapses multiple empty lines to ensure
	 * clean formatting.
	 *
	 * @param  mixed  $object  The source object, expected to be an array with 'output' key.
	 *
	 * @return string         The formatted output content, or an empty string if invalid.
	 *
	 * @since 1.0.1
	 */
	public function get_entry_output( $object ): string {
		if ( empty( $object ) || ! is_array( $object ) ) {
			return '';
		}

		return wp_kses_post( $object['content'] );
	}
}