<?php

namespace Limb_Chatbot\Includes\Services\Knowledge\Knowledge_Mappers;

use Limb_Chatbot\Includes\Data_Objects\File;
use Limb_Chatbot\Includes\Exceptions\Error_Codes;
use Limb_Chatbot\Includes\Exceptions\Exception;
use Limb_Chatbot\Includes\Interfaces\Knowledge_Mapper_Interface;

class File_Knowledge_Mapper implements Knowledge_Mapper_Interface {
	public function get_entry_input( $object ): string {
		if ( ! $object instanceof File ) {
			throw new Exception( Error_Codes::VALIDATION_INVALID_VALUE,
				__( 'Invalid object type. Expected instance of File.', 'limb-chatbot' ) );
		}

		return $object->get_original_name();
	}

	public function get_entry_output( $object ): string {
		return '[File content will be processed and summarized by the AI model.]';
	}
}