<?php

namespace Limb_Chatbot\Includes\Services\Jobs\Processors;

use Limb_Chatbot\Includes\Data_Objects\Job;
use Limb_Chatbot\Includes\Interfaces\Task_Processor_Interface;
use Limb_Chatbot\Includes\Repositories\Job_Repository;
use Limb_Chatbot\Includes\Repositories\Job_Task_Repository;
use Limb_Chatbot\Includes\Services\Jobs\Job_Stats_Service;

class Child_Task_Processor extends Standard_Task_Processor implements Task_Processor_Interface {

	/**
	 * Stats service instance.
	 *
	 * @var Job_Stats_Service
	 * @since 1.1.0
	 */
	private Job_Stats_Service $stats_service;

	/**
	 * Constructor.
	 *
	 * @since 1.1.0
	 */
	public function __construct() {
		parent::__construct();
		$this->stats_service = new Job_Stats_Service();
	}

	/**
	 * Update job statistics for multitask handlers.
	 *
	 * Uses unified stats format from Job_Stats_Service.
	 *
	 * @param  Job  $job  Job instance.
	 * @param  Job_Repository  $job_repository  Job repository.
	 * @param  Job_Task_Repository  $task_repository  Task repository.
	 *
	 * @return void
	 * @since 1.1.0
	 */
	public function update_stats(
		Job $job,
		Job_Repository $job_repository,
		Job_Task_Repository $task_repository
	): void {
		// Calculate unified stats using stats service
		$stats = $this->stats_service->calculate_multitask_stats( $job, $task_repository );

		// Update job stats and progress
		$job->set_stats( $stats );
		$job->set_progress_percent( $stats['progress_percent'] );
		$job->save();
	}
}