<?php

namespace Limb_Chatbot\Includes\Services\Jobs\Processors;

use Limb_Chatbot\Includes\Data_Objects\Job;
use Limb_Chatbot\Includes\Data_Objects\Task;
use Limb_Chatbot\Includes\Interfaces\Job_Handler_Interface;
use Limb_Chatbot\Includes\Interfaces\Multitask_Handler_Interface;
use Limb_Chatbot\Includes\Interfaces\Task_Processor_Interface;
use Limb_Chatbot\Includes\Repositories\Job_Repository;
use Limb_Chatbot\Includes\Repositories\Job_Task_Repository;

class Child_Task_Generation_Processor implements Task_Processor_Interface {

	/**
	 * Process a parent task by generating child tasks.
	 *
	 * @param  Task  $task  Parent task to process.
	 * @param  Job_Handler_Interface  $handler  Job handler.
	 * @param  Job  $job  Job instance.
	 *
	 * @return bool True if successful.
	 * @since 1.1.0
	 */
	public function process( Task $task, Job_Handler_Interface $handler, Job $job ): bool {
		if ( ! $handler instanceof Multitask_Handler_Interface ) {
			return false;
		}
		$handler->generate_sub_tasks( $task );

		return true;
	}

	/**
	 * Update job statistics.
	 *
	 * For child task generation, we don't update stats here as the child tasks
	 * will be processed separately and stats will be updated then.
	 *
	 * @param  Job  $job  Job instance.
	 * @param  Job_Repository  $job_repository  Job repository.
	 * @param  Job_Task_Repository  $task_repository  Task repository.
	 *
	 * @return void
	 * @since 1.1.0
	 */
	public function update_stats(
		Job $job,
		Job_Repository $job_repository,
		Job_Task_Repository $task_repository
	): void {
		// Stats will be updated when child tasks are processed
		// No action needed here
	}
}