<?php

namespace Limb_Chatbot\Includes\Services;

/**
 * Class Widget_Item_Collection
 *
 * A collection specifically designed to hold widget item objects.
 *
 * @extends Collection<object>
 *
 * @since 1.0.0
 */
class Widget_Item_Collection extends Collection {

	/**
	 * Specify data which should be serialized to JSON.
	 *
	 * This method is invoked automatically when json_encode() is called on an instance of this class.
	 *
	 * @return array<object> The array of items contained in the collection to be serialized.
	 *
	 * @since 1.0.0
	 */
	#[\ReturnTypeWillChange]
	public function jsonSerialize() {
		return $this->items;
	}
}